"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = exports.AppWithoutRouter = exports.App = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactDom = require("react-dom");
var _i18nReact = require("@kbn/i18n-react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _reactQuery = require("@tanstack/react-query");
var _suspended_component_with_props = require("./lib/suspended_component_with_props");
var _constants = require("./constants");
var _data_apis = require("../common/lib/data_apis");
var _kibana = require("../common/lib/kibana");
var _connector_context = require("./context/connector_context");
var _constants2 = require("../common/constants");
var _query_client = require("./query_client");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const TriggersActionsUIHome = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./home'))));
const RuleDetailsRoute = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./sections/rule_details/components/rule_details_route'))));
const renderApp = deps => {
  const {
    element
  } = deps;
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(App, {
    deps: deps
  }), element);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(element);
  };
};
exports.renderApp = renderApp;
const App = ({
  deps
}) => {
  const {
    dataViews,
    uiSettings,
    theme$
  } = deps;
  const sections = ['rules', 'logs', 'alerts'];
  const isDarkMode = (0, _useObservable.default)(uiSettings.get$('theme:darkMode'));
  const sectionsRegex = sections.join('|');
  (0, _data_apis.setDataViewsService)(dataViews);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkMode
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_kibana.KibanaContextProvider, {
    services: {
      ...deps,
      theme: {
        theme$
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: deps.history
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: _query_client.queryClient
  }, /*#__PURE__*/_react.default.createElement(AppWithoutRouter, {
    sectionsRegex: sectionsRegex
  })))))));
};
exports.App = App;
const AppWithoutRouter = ({
  sectionsRegex
}) => {
  const {
    actions: {
      validateEmailAddresses
    },
    application: {
      navigateToApp
    }
  } = (0, _kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_connector_context.ConnectorProvider, {
    value: {
      services: {
        validateEmailAddresses
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/:section(${sectionsRegex})`,
    component: (0, _suspended_component_with_props.suspendedComponentWithProps)(TriggersActionsUIHome, 'xl')
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _ruleDataUtils.ruleDetailsRoute,
    component: (0, _suspended_component_with_props.suspendedComponentWithProps)(RuleDetailsRoute, 'xl')
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.legacyRouteToRuleDetails,
    render: ({
      match
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: `/rule/${match.params.alertId}`
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.routeToConnectors,
    render: () => {
      navigateToApp(`management/insightsAndAlerting/${_constants2.CONNECTORS_PLUGIN_ID}`);
      return null;
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: '/',
    to: "rules"
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: '/alerts',
    to: "rules"
  })));
};
exports.AppWithoutRouter = AppWithoutRouter;