"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoute = registerRoute;
var _transforms = require("../../../../common/api_schemas/transforms");
var _constants = require("../../../../common/constants");
var _route_handler = require("./route_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoute({
  router,
  license
}) {
  /**
   * @apiGroup Transforms
   *
   * @api {post} /internal/transform/transforms/_preview Preview transform
   * @apiName PreviewTransform
   * @apiDescription Previews transform
   *
   * @apiSchema (body) postTransformsPreviewRequestSchema
   */
  router.versioned.post({
    path: (0, _constants.addInternalBasePath)('transforms/_preview'),
    access: 'internal'
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: _transforms.postTransformsPreviewRequestSchema
      }
    }
  }, license.guardApiRoute(_route_handler.routeHandler));
}