"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSelection = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _app_dependencies = require("../../../../app_dependencies");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fixedPageSize = 8;
const SearchSelection = ({
  onSearchSelected,
  createNewDataView,
  canEditDataView
}) => {
  const {
    contentManagement,
    uiSettings
  } = (0, _app_dependencies.useAppDependencies)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.newTransform.newTransformTitle",
    defaultMessage: "New transform"
  }), ' ', "/", ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.newTransform.chooseSourceTitle",
    defaultMessage: "Choose a source"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    key: "searchSavedObjectFinder",
    onChoose: onSearchSelected,
    showFilter: true,
    noItemsMessage: _i18n.i18n.translate('xpack.transform.newTransform.searchSelection.notFoundLabel', {
      defaultMessage: 'No matching indices or saved searches found.'
    }),
    savedObjectMetaData: [{
      type: 'search',
      getIconForSavedObject: () => 'search',
      name: _i18n.i18n.translate('xpack.transform.newTransform.searchSelection.savedObjectType.search', {
        defaultMessage: 'Saved search'
      })
    }, {
      type: 'index-pattern',
      getIconForSavedObject: () => 'indexPatternApp',
      name: _i18n.i18n.translate('xpack.transform.newTransform.searchSelection.savedObjectType.dataView', {
        defaultMessage: 'Data view'
      })
    }],
    fixedPageSize: fixedPageSize,
    services: {
      contentClient: contentManagement.client,
      uiSettings
    }
  }, canEditDataView ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: createNewDataView,
    iconType: "plusInCircle",
    "data-test-subj": "newDataViewButton",
    disabled: !canEditDataView
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.newTransform.searchSelection.createADataView",
    defaultMessage: "Create a data view"
  })) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null))));
};
exports.SearchSelection = SearchSelection;