"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStartAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _transform_list = require("../../../../common/transform_list");
var _constants = require("../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _start_action_name = require("./start_action_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStartAction = (forceDisable, transformNodes) => {
  const {
    canStartStopTransform
  } = (0, _hooks.useTransformCapabilities)();
  const startTransforms = (0, _hooks.useStartTransforms)();
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [items, setItems] = (0, _react.useState)([]);
  const closeModal = () => setModalVisible(false);
  const startAndCloseModal = () => {
    setModalVisible(false);
    startTransforms(items.map(i => ({
      id: i.id
    })));
  };
  const openModal = newItems => {
    if (Array.isArray(newItems)) {
      setItems(newItems);
      setModalVisible(true);
    }
  };
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_start_action_name.StartActionName, {
      items: [item],
      forceDisable: forceDisable,
      transformNodes: transformNodes
    }),
    available: item => (0, _transform_list.isTransformListRowWithStats)(item) ? item.stats.state === _constants.TRANSFORM_STATE.STOPPED : true,
    enabled: item => !(0, _start_action_name.isStartActionDisabled)([item], canStartStopTransform, transformNodes),
    description: _start_action_name.startActionNameText,
    icon: 'play',
    type: 'icon',
    onClick: item => openModal([item]),
    'data-test-subj': 'transformActionStart'
  }), [canStartStopTransform, forceDisable, transformNodes]);
  return {
    action,
    closeModal,
    isModalVisible,
    items,
    openModal,
    startAndCloseModal
  };
};
exports.useStartAction = useStartAction;