"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleNowActionNameText = exports.isScheduleNowActionDisabled = exports.ScheduleNowActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _transform_list = require("../../../../common/transform_list");
var _create_stats_unknown_message = require("../../../../../../common/utils/create_stats_unknown_message");
var _create_capability_failure_message = require("../../../../../../common/utils/create_capability_failure_message");
var _hooks = require("../../../../hooks");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scheduleNowActionNameText = _i18n.i18n.translate('xpack.transform.transformList.scheduleNowActionNameText', {
  defaultMessage: 'Schedule now'
});
exports.scheduleNowActionNameText = scheduleNowActionNameText;
const isScheduleNowActionDisabled = (items, canScheduleNowTransform, transformNodes) => {
  // Disable schedule-now for batch transforms which have completed.
  const completedBatchTransform = items.some(i => (0, _common.isCompletedBatchTransform)(i));
  return !canScheduleNowTransform || completedBatchTransform || items.length === 0 || transformNodes === 0 || (0, _transform_list.missingTransformStats)(items);
};
exports.isScheduleNowActionDisabled = isScheduleNowActionDisabled;
const ScheduleNowActionName = ({
  items,
  forceDisable,
  transformNodes
}) => {
  const {
    canScheduleNowTransform
  } = (0, _hooks.useTransformCapabilities)();
  const isBulkAction = items.length > 1;

  // Disable schedule-now for batch transforms which have completed.
  const completedBatchTransform = items.some(i => (0, _common.isCompletedBatchTransform)(i));
  let completedBatchTransformMessage;
  if (isBulkAction === true) {
    completedBatchTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.cannotScheduleNowCompleteBatchTransformBulkActionToolTip', {
      defaultMessage: 'One or more transforms are completed batch transforms and cannot be scheduled to process data instantly.'
    });
  } else {
    completedBatchTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.cannotScheduleNowCompleteBatchTransformToolTip', {
      defaultMessage: '{transformId} is a completed batch transform and cannot be scheduled to process data instantly.',
      values: {
        transformId: items[0] && items[0].config.id
      }
    });
  }
  const actionIsDisabled = isScheduleNowActionDisabled(items, canScheduleNowTransform, transformNodes);
  let content = _i18n.i18n.translate('xpack.transform.transformList.scheduleNowToolTip', {
    defaultMessage: 'Schedule the transform to instantly process data without waiting for the configured interval between checks for changes in the source indices.'
  });
  if (actionIsDisabled && items.length > 0) {
    if (!canScheduleNowTransform) {
      content = (0, _create_capability_failure_message.createCapabilityFailureMessage)('canScheduleNowTransform');
    } else if (completedBatchTransform) {
      content = completedBatchTransformMessage;
    } else if ((0, _transform_list.missingTransformStats)(items)) {
      content = (0, _create_stats_unknown_message.createNoStatsTooltipMessage)({
        actionName: scheduleNowActionNameText,
        count: items.length
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: content
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, scheduleNowActionNameText));
};
exports.ScheduleNowActionName = ScheduleNowActionName;