"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloneAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _hooks = require("../../../../hooks");
var _app_dependencies = require("../../../../app_dependencies");
var _clone_action_name = require("./clone_action_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCloneAction = (forceDisable, transformNodes) => {
  const history = (0, _reactRouterDom.useHistory)();
  const appDeps = (0, _app_dependencies.useAppDependencies)();
  const dataViewsContract = appDeps.data.dataViews;
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const {
    getDataViewIdByTitle,
    loadDataViews
  } = (0, _hooks.useSearchItems)(undefined);
  const {
    canCreateTransform
  } = (0, _hooks.useTransformCapabilities)();
  const clickHandler = (0, _react.useCallback)(async item => {
    try {
      await loadDataViews(dataViewsContract);
      const dataViewTitle = Array.isArray(item.config.source.index) ? item.config.source.index.join(',') : item.config.source.index;
      const dataViewId = getDataViewIdByTitle(dataViewTitle);
      if (dataViewId === undefined) {
        toastNotifications.addDanger(_i18n.i18n.translate('xpack.transform.clone.noDataViewErrorPromptText', {
          defaultMessage: 'Unable to clone the transform {transformId}. No data view exists for {dataViewTitle}.',
          values: {
            dataViewTitle,
            transformId: item.id
          }
        }));
      } else {
        history.push(`/${_constants.SECTION_SLUG.CLONE_TRANSFORM}/${item.id}?dataViewId=${dataViewId}`);
      }
    } catch (e) {
      toastNotifications.addError(e, {
        title: _i18n.i18n.translate('xpack.transform.clone.errorPromptText', {
          defaultMessage: 'An error occurred checking if source data view exists'
        })
      });
    }
  }, [history, dataViewsContract, toastNotifications, loadDataViews, getDataViewIdByTitle]);
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_clone_action_name.CloneActionName, {
      disabled: !canCreateTransform
    }),
    enabled: () => canCreateTransform && !forceDisable && transformNodes > 0,
    description: _clone_action_name.cloneActionNameText,
    icon: 'copy',
    type: 'icon',
    onClick: clickHandler,
    'data-test-subj': 'transformActionClone'
  }), [canCreateTransform, forceDisable, clickHandler, transformNodes]);
  return {
    action
  };
};
exports.useCloneAction = useCloneAction;