"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatestFunctionForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_dependencies = require("../../../../app_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LatestFunctionForm = ({
  copyToClipboard,
  copyToClipboardDescription,
  latestFunctionService
}) => {
  var _latestFunctionServic;
  const {
    ml: {
      useFieldStatsTrigger
    }
  } = (0, _app_dependencies.useAppDependencies)();
  const {
    renderOption,
    closeFlyout
  } = useFieldStatsTrigger();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.stepDefineForm.uniqueKeysLabel",
      defaultMessage: "Unique keys"
    }),
    "data-test-subj": "transformLatestFunctionForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.transform.stepDefineForm.uniqueKeysPlaceholder', {
      defaultMessage: 'Add unique keys ...'
    }),
    options: latestFunctionService.uniqueKeyOptions,
    selectedOptions: (_latestFunctionServic = latestFunctionService.config.unique_key) !== null && _latestFunctionServic !== void 0 ? _latestFunctionServic : [],
    onChange: selected => {
      latestFunctionService.updateLatestFunctionConfig({
        unique_key: selected
      });
      closeFlyout();
    },
    isClearable: false,
    "data-test-subj": "transformWizardUniqueKeysSelector",
    renderOption: renderOption
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.stepDefineForm.sortLabel",
      defaultMessage: "Sort field"
    }),
    helpText: latestFunctionService.sortFieldOptions.length > 0 ? _i18n.i18n.translate('xpack.transform.stepDefineForm.sortHelpText', {
      defaultMessage: 'Select the date field to be used to identify the latest document.'
    }) : undefined
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, latestFunctionService.sortFieldOptions.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.transform.stepDefineForm.sortPlaceholder', {
      defaultMessage: 'Add a date field ...'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: latestFunctionService.sortFieldOptions,
    selectedOptions: latestFunctionService.config.sort ? [latestFunctionService.config.sort] : [],
    onChange: selected => {
      latestFunctionService.updateLatestFunctionConfig({
        sort: {
          value: selected[0].value,
          label: selected[0].label
        }
      });
      closeFlyout();
    },
    isClearable: false,
    "data-test-subj": "transformWizardSortFieldSelector",
    renderOption: renderOption
  }), latestFunctionService.sortFieldOptions.length === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.stepDefineForm.sortFieldOptionsEmptyError",
    defaultMessage: "No date fields are available to sort on. To use another field type, copy the configuration to the clipboard and continue creating the transform in the Console."
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: copyToClipboardDescription,
    textToCopy: copyToClipboard
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": copyToClipboardDescription
  })))))));
};
exports.LatestFunctionForm = LatestFunctionForm;