"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterTermForm = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _use_data_search = require("../../../../../../../hooks/use_data_search");
var _wizard = require("../../../../wizard/wizard");
var _app_dependencies = require("../../../../../../../app_dependencies");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Form component for the term filter aggregation.
 */
const FilterTermForm = ({
  config,
  onChange,
  selectedField
}) => {
  var _data$aggregations, _data$aggregations2;
  const {
    dataView,
    runtimeMappings
  } = (0, _react.useContext)(_wizard.CreateTransformWizardContext);
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const debouncedOnSearchChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(d => setSearchValue(d), 600), []);
  (0, _react.useEffect)(() => {
    // Simulate initial load.
    debouncedOnSearchChange('');
    // Cancel debouncing when unmounting
    return () => debouncedOnSearchChange.cancel();
    // Only call on mount
    /* eslint-disable-next-line react-hooks/exhaustive-deps */
  }, []);
  const updateConfig = (0, _react.useCallback)(update => {
    onChange({
      config: {
        ...config,
        ...update
      }
    });
  }, [config, onChange]);
  const {
    data,
    isError,
    isLoading
  } = (0, _use_data_search.useDataSearch)({
    index: dataView.title,
    body: {
      ...(runtimeMappings !== undefined ? {
        runtime_mappings: runtimeMappings
      } : {}),
      query: {
        wildcard: {
          [selectedField]: {
            value: `*${searchValue}*`
          }
        }
      },
      aggs: {
        field_values: {
          terms: {
            field: selectedField,
            size: 10
          }
        }
      },
      size: 0
    }
  },
  // Check whether fetching should be enabled
  selectedField !== undefined);
  (0, _react.useEffect)(() => {
    if (isError) {
      toastNotifications.addWarning(_i18n.i18n.translate('xpack.transform.agg.popoverForm.filerAgg.term.errorFetchSuggestions', {
        defaultMessage: 'Unable to fetch suggestions'
      }));
    }
    /* eslint-disable-next-line react-hooks/exhaustive-deps */
  }, [isError]);
  const options = (0, _mlAggUtils.isMultiBucketAggregate)(data === null || data === void 0 ? void 0 : (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : _data$aggregations.field_values) ? (data === null || data === void 0 ? void 0 : (_data$aggregations2 = data.aggregations) === null || _data$aggregations2 === void 0 ? void 0 : _data$aggregations2.field_values.buckets).map(value => ({
    label: value.key + ''
  })) : [];
  (0, _useUpdateEffect.default)(() => {
    // Reset value control on field change
    if (!selectedField) return;
    onChange({
      config: {
        value: undefined
      }
    });
  }, [selectedField]);
  const selectedOptions = config !== null && config !== void 0 && config.value ? [{
    label: config.value
  }] : undefined;
  if (selectedField === undefined) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.agg.popoverForm.filerAgg.term.valueLabel",
      defaultMessage: "Value"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    async: true,
    isLoading: isLoading,
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selectedOptions,
    isClearable: false,
    onChange: selected => {
      updateConfig({
        value: selected.length > 0 ? selected[0].label : undefined
      });
    },
    onCreateOption: value => {
      updateConfig({
        value
      });
    },
    onSearchChange: debouncedOnSearchChange,
    "data-test-subj": "transformFilterTermValueSelector"
  }));
};
exports.FilterTermForm = FilterTermForm;