"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepCreateForm = void 0;
exports.getDefaultStepCreateState = getDefaultStepCreateState;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _common = require("@kbn/discover-plugin/common");
var _constants = require("../../../../../../common/constants");
var _errors = require("../../../../../../common/utils/errors");
var _common2 = require("../../../../common");
var _hooks = require("../../../../hooks");
var _app_dependencies = require("../../../../app_dependencies");
var _navigation = require("../../../../common/navigation");
var _components = require("../../../../components");
var _transform = require("../../../../../../common/types/transform");
var _transform_alerting_flyout = require("../../../../../alerting/transform_alerting_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefaultStepCreateState() {
  return {
    created: false,
    started: false,
    dataViewId: undefined
  };
}
const StepCreateForm = /*#__PURE__*/_react.default.memo(({
  createDataView,
  transformConfig,
  transformId,
  onChange,
  overrides,
  timeFieldName
}) => {
  var _application$capabili, _application$capabili2;
  const defaults = {
    ...getDefaultStepCreateState(),
    ...overrides
  };
  const [redirectToTransformManagement, setRedirectToTransformManagement] = (0, _react.useState)(false);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [created, setCreated] = (0, _react.useState)(defaults.created);
  const [started, setStarted] = (0, _react.useState)(defaults.started);
  const [alertFlyoutVisible, setAlertFlyoutVisible] = (0, _react.useState)(false);
  const [dataViewId, setDataViewId] = (0, _react.useState)(defaults.dataViewId);
  const [progressPercentComplete, setProgressPercentComplete] = (0, _react.useState)(undefined);
  const [discoverLink, setDiscoverLink] = (0, _react.useState)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const {
    application,
    i18n: i18nStart,
    share,
    theme
  } = (0, _app_dependencies.useAppDependencies)();
  const isDiscoverAvailable = (_application$capabili = (_application$capabili2 = application.capabilities.discover) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.show) !== null && _application$capabili !== void 0 ? _application$capabili : false;
  (0, _react.useEffect)(() => {
    let unmounted = false;
    onChange({
      created,
      started,
      dataViewId
    });
    const getDiscoverUrl = async () => {
      const locator = share.url.locators.get(_common.DISCOVER_APP_LOCATOR);
      if (!locator) return;
      const discoverUrl = await locator.getUrl({
        indexPatternId: dataViewId
      });
      if (!unmounted) {
        setDiscoverLink(discoverUrl);
      }
    };
    if (started === true && dataViewId !== undefined && isDiscoverAvailable) {
      getDiscoverUrl();
    }
    return () => {
      unmounted = true;
    };
    // custom comparison
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [created, started, dataViewId]);
  const startTransforms = (0, _hooks.useStartTransforms)();
  const createTransform = (0, _hooks.useCreateTransform)();
  function createTransformHandler(startAfterCreation = false) {
    setLoading(true);
    createTransform({
      transformId,
      transformConfig,
      createDataView,
      timeFieldName
    }, {
      onError: () => setCreated(false),
      onSuccess: resp => {
        setCreated(true);
        if (resp.dataViewsCreated.length === 1) {
          setDataViewId(resp.dataViewsCreated[0].id);
        }
        if (startAfterCreation) {
          startTransform();
        }
      },
      onSettled: () => setLoading(false)
    });
  }
  function startTransform() {
    setLoading(true);
    startTransforms([{
      id: transformId
    }], {
      onError: () => setStarted(false),
      onSuccess: resp => {
        var _resp$transformId;
        return setStarted(((_resp$transformId = resp[transformId]) === null || _resp$transformId === void 0 ? void 0 : _resp$transformId.success) === true);
      },
      onSettled: () => setLoading(false)
    });
  }
  const isBatchTransform = typeof transformConfig.sync === 'undefined';
  (0, _react.useEffect)(() => {
    if (loading === false && started === true && progressPercentComplete === undefined && isBatchTransform) {
      setProgressPercentComplete(0);
    }
  }, [loading, started, progressPercentComplete, isBatchTransform]);
  const progressBarRefetchEnabled = isBatchTransform && typeof progressPercentComplete === 'number' && progressPercentComplete < 100;
  const progressBarRefetchInterval = progressBarRefetchEnabled ? _constants.PROGRESS_REFRESH_INTERVAL_MS : false;
  const {
    data: stats
  } = (0, _hooks.useGetTransformStats)(transformId, progressBarRefetchEnabled, progressBarRefetchInterval);
  (0, _react.useEffect)(() => {
    if (stats === undefined) {
      return;
    }
    if (stats && Array.isArray(stats.transforms) && stats.transforms.length > 0) {
      const percent = (0, _common2.getTransformProgress)({
        id: transformId,
        config: {
          ...transformConfig,
          id: transformId
        },
        stats: stats.transforms[0]
      }) || 0;
      setProgressPercentComplete(percent);
    } else {
      toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.transform.stepCreateForm.progressErrorMessage', {
          defaultMessage: 'An error occurred getting the progress percentage:'
        }),
        text: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
          text: (0, _errors.getErrorMessage)(stats)
        }), {
          theme,
          i18n: i18nStart
        })
      });
    }
  }, [i18nStart, stats, theme, toastNotifications, transformConfig, transformId]);
  function getTransformConfigDevConsoleStatement() {
    return `PUT _transform/${transformId}\n${JSON.stringify(transformConfig, null, 2)}\n\n`;
  }

  // TODO move this to SASS
  const FLEX_GROUP_STYLE = {
    height: '90px',
    maxWidth: '800px'
  };
  const FLEX_ITEM_STYLE = {
    width: '200px'
  };
  const PANEL_ITEM_STYLE = {
    width: '300px'
  };
  if (redirectToTransformManagement) {
    return /*#__PURE__*/_react.default.createElement(_navigation.RedirectToTransformManagement, null);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformStepCreateForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, !created && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    style: FLEX_GROUP_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: FLEX_ITEM_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: loading || created && started,
    onClick: () => createTransformHandler(true),
    "data-test-subj": "transformWizardCreateAndStartButton"
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.createAndStartTransformButton', {
    defaultMessage: 'Create and start'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.createAndStartTransformDescription', {
    defaultMessage: 'Creates and starts the transform. A transform will increase search and indexing load in your cluster. Please stop the transform if excessive load is experienced. After the transform is started, you will be offered options to continue exploring the transform.'
  })))), created && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    style: FLEX_GROUP_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: FLEX_ITEM_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: loading || created && started,
    onClick: startTransform,
    "data-test-subj": "transformWizardStartButton"
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.startTransformButton', {
    defaultMessage: 'Start'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.startTransformDescription', {
    defaultMessage: 'Starts the transform. A transform will increase search and indexing load in your cluster. Please stop the transform if excessive load is experienced. After the transform is started, you will be offered options to continue exploring the transform.'
  })))), (0, _transform.isContinuousTransform)(transformConfig) && created ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    style: FLEX_GROUP_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: FLEX_ITEM_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: loading,
    onClick: setAlertFlyoutVisible.bind(null, true),
    "data-test-subj": "transformWizardCreateAlertButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.stepCreateForm.createAlertRuleButton",
    defaultMessage: "Create alert rule"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.createAlertRuleDescription', {
    defaultMessage: 'Opens a wizard to create an alert rule for monitoring transform health.'
  })))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    style: FLEX_GROUP_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: FLEX_ITEM_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: loading || created,
    onClick: () => createTransformHandler(),
    "data-test-subj": "transformWizardCreateButton"
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.createTransformButton', {
    defaultMessage: 'Create'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.createTransformDescription', {
    defaultMessage: 'Creates the transform without starting it. You will be able to start the transform later by returning to the transforms list.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    style: FLEX_GROUP_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: FLEX_ITEM_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: getTransformConfigDevConsoleStatement()
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: copy,
    style: {
      width: '100%'
    },
    "data-test-subj": "transformWizardCopyToClipboardButton"
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.copyTransformConfigToClipboardButton', {
    defaultMessage: 'Copy to clipboard'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.copyTransformConfigToClipboardDescription', {
    defaultMessage: 'Copies to the clipboard the Kibana Dev Console command for creating the transform.'
  })))), progressPercentComplete !== undefined && isBatchTransform && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.transform.stepCreateForm.progressTitle', {
    defaultMessage: 'Progress'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '400px'
    },
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "l",
    color: "primary",
    value: progressPercentComplete,
    max: 100,
    "data-test-subj": "transformWizardProgressBar"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, progressPercentComplete, "%")))), created && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: PANEL_ITEM_STYLE,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "list"
    }),
    title: _i18n.i18n.translate('xpack.transform.stepCreateForm.transformListCardTitle', {
      defaultMessage: 'Transforms'
    }),
    description: _i18n.i18n.translate('xpack.transform.stepCreateForm.transformListCardDescription', {
      defaultMessage: 'Return to the transform management page.'
    }),
    onClick: () => setRedirectToTransformManagement(true),
    "data-test-subj": "transformWizardCardManagement"
  })), started === true && createDataView === true && dataViewId === undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: PANEL_ITEM_STYLE,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary",
    position: "absolute"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.transform.stepCreateForm.creatingDataViewMessage', {
    defaultMessage: 'Creating Kibana data view ...'
  }))))), isDiscoverAvailable && discoverLink !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: PANEL_ITEM_STYLE,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "discoverApp"
    }),
    title: _i18n.i18n.translate('xpack.transform.stepCreateForm.discoverCardTitle', {
      defaultMessage: 'Discover'
    }),
    description: _i18n.i18n.translate('xpack.transform.stepCreateForm.discoverCardDescription', {
      defaultMessage: 'Use Discover to explore the transform.'
    }),
    href: discoverLink,
    "data-test-subj": "transformWizardCardDiscover"
  }))))), alertFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_transform_alerting_flyout.TransformAlertFlyout, {
    ruleParams: {
      includeTransforms: [transformId]
    },
    onCloseFlyout: setAlertFlyoutVisible.bind(null, false)
  }) : null);
});
exports.StepCreateForm = StepCreateForm;