"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PivotConfigurationContext = exports.PivotConfiguration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _app_dependencies = require("../../../../app_dependencies");
var _aggregation_list = require("../aggregation_list");
var _aggregation_dropdown = require("../aggregation_dropdown");
var _group_by_list = require("../group_by_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PivotConfigurationContext = /*#__PURE__*/(0, _react.createContext)(undefined);
exports.PivotConfigurationContext = PivotConfigurationContext;
const PivotConfiguration = /*#__PURE__*/(0, _react.memo)(({
  actions,
  state
}) => {
  const {
    ml: {
      useFieldStatsTrigger,
      FieldStatsInfoButton
    }
  } = (0, _app_dependencies.useAppDependencies)();
  const {
    handleFieldStatsButtonClick,
    closeFlyout,
    renderOption,
    populatedFields
  } = useFieldStatsTrigger();
  const {
    addAggregation,
    addGroupBy,
    deleteAggregation,
    deleteGroupBy,
    updateAggregation,
    updateGroupBy
  } = actions;
  const {
    aggList,
    aggOptions,
    aggOptionsData,
    groupByList,
    groupByOptions,
    groupByOptionsData
  } = state;
  const aggOptionsWithFieldStats = (0, _react.useMemo)(() => aggOptions.map(({
    label,
    field,
    options
  }) => {
    const aggOption = {
      isGroupLabelOption: true,
      key: field.id,
      // @ts-ignore Purposefully passing label as element instead of string
      // for more robust rendering
      label: /*#__PURE__*/_react.default.createElement(FieldStatsInfoButton, {
        isEmpty: populatedFields && !populatedFields.has(field.id),
        field: field,
        label: label,
        onButtonClick: handleFieldStatsButtonClick
      }),
      options: options !== null && options !== void 0 ? options : []
    };
    return aggOption;
  }), [aggOptions, FieldStatsInfoButton, handleFieldStatsButtonClick, populatedFields]);
  return /*#__PURE__*/_react.default.createElement(PivotConfigurationContext.Provider, {
    value: {
      actions,
      state
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.groupByLabel', {
      defaultMessage: 'Group by'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_group_by_list.GroupByListForm, {
    list: groupByList,
    options: groupByOptionsData,
    onChange: updateGroupBy,
    deleteHandler: deleteGroupBy
  }), /*#__PURE__*/_react.default.createElement(_aggregation_dropdown.DropDown, {
    changeHandler: addGroupBy,
    options: groupByOptions,
    placeholder: _i18n.i18n.translate('xpack.transform.stepDefineForm.groupByPlaceholder', {
      defaultMessage: 'Add a group by field ...'
    }),
    testSubj: "transformGroupBySelection",
    renderOption: renderOption
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.aggregationsLabel', {
      defaultMessage: 'Aggregations'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_aggregation_list.AggListForm, {
    list: aggList,
    options: aggOptionsData,
    onChange: (aggName, pivotAggsConfig) => {
      updateAggregation(aggName, pivotAggsConfig);
      closeFlyout();
    },
    deleteHandler: deleteAggregation
  }), /*#__PURE__*/_react.default.createElement(_aggregation_dropdown.DropDown, {
    changeHandler: option => {
      addAggregation(option);
      closeFlyout();
    },
    options: aggOptionsWithFieldStats,
    placeholder: _i18n.i18n.translate('xpack.transform.stepDefineForm.aggregationsPlaceholder', {
      defaultMessage: 'Add an aggregation ...'
    }),
    testSubj: "transformAggregationSelection"
  }))));
});
exports.PivotConfiguration = PivotConfiguration;