"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByLabelForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("../../../../common");
var _popover_form = require("./popover_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupByLabelForm = ({
  deleteHandler,
  item,
  otherAggNames,
  onChange,
  options
}) => {
  const [isPopoverVisible, setPopoverVisibility] = (0, _react.useState)(false);
  function update(updateItem) {
    onChange({
      ...updateItem
    });
    setPopoverVisibility(false);
  }
  let interval;
  if ((0, _common.isGroupByDateHistogram)(item)) {
    interval = item.calendar_interval;
  } else if ((0, _common.isGroupByHistogram)(item)) {
    interval = item.interval;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "transform__GroupByLabel--text"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate",
    "data-test-subj": "transformGroupByEntryLabel"
  }, item.aggName)), interval !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "transform__GroupByLabel--text transform__GroupByLabel--interval"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    className: "eui-textTruncate",
    "data-test-subj": "transformGroupByEntryIntervalLabel"
  }, interval)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "transform__GroupByLabel--button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "transformIntervalFormPopover",
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.transform.groupByLabelForm.editIntervalAriaLabel', {
        defaultMessage: 'Edit interval'
      }),
      size: "s",
      iconType: "pencil",
      onClick: () => setPopoverVisibility(!isPopoverVisible),
      "data-test-subj": "transformGroupByEntryEditButton"
    }),
    isOpen: isPopoverVisible,
    closePopover: () => setPopoverVisibility(false)
  }, /*#__PURE__*/_react.default.createElement(_popover_form.PopoverForm, {
    defaultData: item,
    onChange: update,
    otherAggNames: otherAggNames,
    options: options
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "transform__GroupByLabel--button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.transform.groupByLabelForm.deleteItemAriaLabel', {
      defaultMessage: 'Delete item'
    }),
    size: "s",
    iconType: "cross",
    onClick: () => deleteHandler(item.aggName),
    "data-test-subj": "transformGroupByEntryDeleteButton"
  })));
};
exports.GroupByLabelForm = GroupByLabelForm;