"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformSelectorControl = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _mlIsDefined = require("@kbn/ml-is-defined");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertToEuiOptions(values) {
  return values.map(v => ({
    value: v,
    label: v
  }));
}
const TransformSelectorControl = ({
  label,
  errors,
  onChange,
  selectedOptions,
  options,
  allowSelectAll = false
}) => {
  const onSelectionChange = selectionUpdate => {
    if (!(selectionUpdate !== null && selectionUpdate !== void 0 && selectionUpdate.length)) {
      onChange([]);
      return;
    }
    if (selectionUpdate[selectionUpdate.length - 1].value === _constants.ALL_TRANSFORMS_SELECTION) {
      onChange([_constants.ALL_TRANSFORMS_SELECTION]);
      return;
    }
    onChange(selectionUpdate.slice(selectionUpdate[0].value === _constants.ALL_TRANSFORMS_SELECTION ? 1 : 0).map(v => v.value).filter(_mlIsDefined.isDefined));
  };
  const selectedOptionsEui = (0, _react.useMemo)(() => convertToEuiOptions(selectedOptions), [selectedOptions]);
  const optionsEui = (0, _react.useMemo)(() => {
    return convertToEuiOptions(allowSelectAll ? [_constants.ALL_TRANSFORMS_SELECTION, ...options] : options);
  }, [options, allowSelectAll]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: label,
    isInvalid: !!(errors !== null && errors !== void 0 && errors.length),
    error: errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: false,
    selectedOptions: selectedOptionsEui,
    options: optionsEui,
    onChange: onSelectionChange,
    fullWidth: true,
    "data-test-subj": 'transformSelection',
    isInvalid: !!(errors !== null && errors !== void 0 && errors.length)
  }));
};
exports.TransformSelectorControl = TransformSelectorControl;