"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAdditionalScreenReaderOnlyContext = exports.createFilter = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAdditionalScreenReaderOnlyContext = ({
  field,
  value
}) => {
  if (value == null) {
    return field;
  }
  return Array.isArray(value) ? `${field} ${value.join(' ')}` : `${field} ${value}`;
};
exports.getAdditionalScreenReaderOnlyContext = getAdditionalScreenReaderOnlyContext;
const createFilter = (key, value, negate = false) => {
  const queryValue = value != null ? Array.isArray(value) ? value[0] : value : null;
  return queryValue != null ? {
    meta: {
      alias: null,
      negate,
      disabled: false,
      type: 'phrase',
      key,
      value: queryValue,
      params: {
        query: queryValue
      }
    },
    query: {
      match: {
        [key]: {
          query: queryValue,
          type: 'phrase'
        }
      }
    }
  } : {
    exists: {
      field: key
    },
    meta: {
      alias: null,
      disabled: false,
      key,
      negate: value === undefined,
      type: 'exists',
      value: 'exists'
    }
  };
};
exports.createFilter = createFilter;