"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSourcererDataView = void 0;
var _react = require("react");
var _indicator = require("../../../../common/types/indicator");
var _use_security_context = require("../../../hooks/use_security_context");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Inline definition for a runtime field "threat.indicator.name" we are adding for indicators grid
 */
const indicatorNameField = {
  aggregatable: true,
  name: _indicator.RawIndicatorFieldId.Name,
  searchable: true,
  type: 'string',
  category: 'threat',
  description: _translations.DESCRIPTION,
  esTypes: ['keyword']
};
const useSourcererDataView = () => {
  const {
    sourcererDataView
  } = (0, _use_security_context.useSecurityContext)();
  const updatedPattern = (0, _react.useMemo)(() => {
    const fields = [...sourcererDataView.indexPattern.fields, indicatorNameField];
    return {
      ...sourcererDataView.indexPattern,
      fields
    };
  }, [sourcererDataView.indexPattern]);
  const indexPatterns = (0, _react.useMemo)(() => [updatedPattern], [updatedPattern]);
  const browserFields = (0, _react.useMemo)(() => {
    const {
      threat = {
        fields: {}
      }
    } = sourcererDataView.browserFields;
    return {
      ...sourcererDataView.browserFields,
      threat: {
        fields: {
          ...threat.fields,
          [indicatorNameField.name]: indicatorNameField
        }
      }
    };
  }, [sourcererDataView.browserFields]);
  return (0, _react.useMemo)(() => ({
    sourcererDataView,
    indexPatterns,
    indexPattern: updatedPattern,
    browserFields
  }), [browserFields, indexPatterns, sourcererDataView, updatedPattern]);
};
exports.useSourcererDataView = useSourcererDataView;