"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAggregatedIndicators = void 0;
var _reactQuery = require("@tanstack/react-query");
var _react = require("react");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_inspector = require("../../../hooks/use_inspector");
var _indicator = require("../../../../common/types/indicator");
var _use_sourcerer_data_view = require("./use_sourcerer_data_view");
var _fetch_aggregated_indicators = require("../services/fetch_aggregated_indicators");
var _use_kibana_ui_settings = require("../../../hooks/use_kibana_ui_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_FIELD = _indicator.RawIndicatorFieldId.Feed;
const QUERY_ID = 'indicatorsBarchart';
const useAggregatedIndicators = ({
  timeRange,
  filters,
  filterQuery
}) => {
  const {
    services: {
      data: {
        search: searchService,
        query: queryService
      }
    }
  } = (0, _use_kibana.useKibana)();
  const userTimeZone = (0, _use_kibana_ui_settings.useTimeZone)();
  const userFormat = (0, _use_kibana_ui_settings.useDateFormat)();
  const {
    sourcererDataView: {
      selectedPatterns
    }
  } = (0, _use_sourcerer_data_view.useSourcererDataView)();
  const {
    inspectorAdapters
  } = (0, _use_inspector.useInspector)();
  const [field, setField] = (0, _react.useState)({
    label: DEFAULT_FIELD,
    value: 'string'
  });
  const aggregatedIndicatorsQuery = (0, _react.useMemo)(() => (0, _fetch_aggregated_indicators.createFetchAggregatedIndicators)({
    queryService,
    searchService,
    inspectorAdapter: inspectorAdapters.requests,
    userTimeZone,
    userFormat
  }), [inspectorAdapters.requests, queryService, searchService, userFormat, userTimeZone]);
  const {
    data,
    isLoading,
    isFetching,
    refetch
  } = (0, _reactQuery.useQuery)([QUERY_ID, {
    filters,
    field,
    filterQuery,
    selectedPatterns,
    timeRange
  }], ({
    signal,
    queryKey: [_key, queryParams]
  }) => aggregatedIndicatorsQuery(queryParams, signal), {
    keepPreviousData: true
  });
  const dateRange = (0, _react.useMemo)(() => queryService.timefilter.timefilter.calculateBounds(timeRange), [queryService.timefilter.timefilter, timeRange]);
  const query = (0, _react.useMemo)(() => ({
    refetch,
    id: QUERY_ID,
    loading: isLoading
  }), [isLoading, refetch]);
  return {
    dateRange,
    series: data || [],
    onFieldChange: setField,
    selectedField: field,
    isLoading,
    isFetching,
    query
  };
};
exports.useAggregatedIndicators = useAggregatedIndicators;