"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _cell_actions = require("./cell_actions");
var _cell_popover_renderer = require("./cell_popover_renderer");
var _cell_renderer = require("./cell_renderer");
var _indicator = require("../../../../../common/types/indicator");
var _empty_state = require("../../../../components/empty_state");
var _use_table_context = require("../../hooks/use_table_context");
var _flyout = require("../flyout/flyout");
var _use_toolbar_options = require("../../hooks/use_toolbar_options");
var _use_field_types = require("../../../../hooks/use_field_types");
var _get_field_schema = require("../../utils/get_field_schema");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const gridStyle = {
  border: 'horizontal',
  header: 'underline',
  cellPadding: 'm',
  fontSize: 's'
};
const IndicatorsTable = ({
  indicators,
  indicatorCount,
  onChangePage,
  onChangeItemsPerPage,
  pagination,
  isLoading,
  isFetching,
  browserFields,
  columnSettings: {
    columns,
    columnVisibility,
    handleResetColumns,
    handleToggleColumn,
    sorting
  }
}) => {
  const [expanded, setExpanded] = (0, _react.useState)();
  const fieldTypes = (0, _use_field_types.useFieldTypes)();
  const renderCellValue = (0, _react.useMemo)(() => (0, _cell_renderer.cellRendererFactory)(pagination.pageIndex * pagination.pageSize), [pagination.pageIndex, pagination.pageSize]);
  const renderCellPopoverValue = (0, _react.useMemo)(() => (0, _cell_popover_renderer.cellPopoverRendererFactory)(indicators, pagination), [indicators, pagination]);
  const indicatorTableContextValue = (0, _react.useMemo)(() => ({
    expanded,
    setExpanded,
    indicators
  }), [expanded, indicators]);
  const start = pagination.pageIndex * pagination.pageSize;
  const end = start + pagination.pageSize;
  const leadingControlColumns = (0, _react.useMemo)(() => [{
    id: 'Actions',
    width: 84,
    headerCellRender: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.threatIntelligence.indicator.table.actionColumnLabel",
      defaultMessage: "Actions"
    }),
    rowCellRender: renderCellValue
  }], [renderCellValue]);
  const mappedColumns = (0, _react.useMemo)(() => columns.map(col => {
    var _browserFields$col$id;
    return {
      ...col,
      isSortable: col.id !== _indicator.RawIndicatorFieldId.Id && ((_browserFields$col$id = browserFields[col.id]) === null || _browserFields$col$id === void 0 ? void 0 : _browserFields$col$id.aggregatable),
      schema: (0, _get_field_schema.getFieldSchema)(fieldTypes[col.id]),
      cellActions: [({
        rowIndex,
        columnId,
        Component
      }) => /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
        rowIndex: rowIndex,
        columnId: columnId,
        Component: Component,
        indicators: indicators,
        pagination: pagination
      })]
    };
  }), [browserFields, columns, fieldTypes, indicators, pagination]);
  const toolbarOptions = (0, _use_toolbar_options.useToolbarOptions)({
    browserFields,
    start,
    end,
    indicatorCount,
    columns,
    onResetColumns: handleResetColumns,
    onToggleColumn: handleToggleColumn
  });
  const flyoutFragment = (0, _react.useMemo)(() => expanded ? /*#__PURE__*/_react.default.createElement(_flyout.IndicatorsFlyout, {
    indicator: expanded,
    closeFlyout: () => setExpanded(undefined)
  }) : null, [expanded]);
  const gridFragment = (0, _react.useMemo)(() => {
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceAround"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        hasShadow: false,
        hasBorder: false,
        paddingSize: "xl"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl"
      }))));
    }
    const rowHeightsOptions = {
      lineHeight: '30px'
    };
    if (!indicatorCount) {
      return /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, null);
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFetching && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      "data-test-subj": _test_ids.TABLE_UPDATE_PROGRESS_TEST_ID,
      size: "xs",
      color: "accent",
      position: "absolute"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
      "aria-labelledby": "indicators-table",
      leadingControlColumns: leadingControlColumns,
      rowCount: indicatorCount,
      renderCellValue: renderCellValue,
      renderCellPopover: renderCellPopoverValue,
      toolbarVisibility: toolbarOptions,
      pagination: {
        ...pagination,
        onChangeItemsPerPage,
        onChangePage
      },
      gridStyle: gridStyle,
      "data-test-subj": _test_ids.TABLE_TEST_ID,
      sorting: sorting,
      columnVisibility: columnVisibility,
      columns: mappedColumns,
      rowHeightsOptions: rowHeightsOptions
    }));
  }, [isLoading, indicatorCount, isFetching, leadingControlColumns, renderCellValue, renderCellPopoverValue, toolbarOptions, pagination, onChangeItemsPerPage, onChangePage, sorting, columnVisibility, mappedColumns]);
  return /*#__PURE__*/_react.default.createElement(_use_table_context.IndicatorsTableContext.Provider, {
    value: indicatorTableContextValue
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'relative'
    }
  }, flyoutFragment, gridFragment));
};
exports.IndicatorsTable = IndicatorsTable;