"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorFieldsTable = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _field_value = require("../common/field_value");
var _indicator_value_actions = require("./indicator_value_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicatorFieldsTable = ({
  fields,
  indicator,
  'data-test-subj': dataTestSubj
}) => {
  const columns = (0, _react.useMemo)(() => [{
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.threatIntelligence.indicator.fieldsTable.fieldColumnLabel",
      defaultMessage: "Field"
    }),
    render: field => field
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.threatIntelligence.indicator.fieldsTable.valueColumnLabel",
      defaultMessage: "Value"
    }),
    render: field => /*#__PURE__*/_react.default.createElement(_field_value.IndicatorFieldValue, {
      indicator: indicator,
      field: field
    })
  }, {
    actions: [{
      render: field => /*#__PURE__*/_react.default.createElement(_indicator_value_actions.IndicatorValueActions, {
        field: field,
        indicator: indicator,
        "data-test-subj": dataTestSubj
      }),
      width: '72px'
    }]
  }], [indicator, dataTestSubj]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: fields.sort(),
    columns: columns,
    sorting: true,
    "data-test-subj": dataTestSubj
  });
};
exports.IndicatorFieldsTable = IndicatorFieldsTable;