"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsFieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _indicator = require("../../../../../common/types/indicator");
var _styles = require("./styles");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_STACK_BY_VALUE = _indicator.RawIndicatorFieldId.Feed;
const COMBOBOX_SINGLE_SELECTION = {
  asPlainText: true
};
const IndicatorsFieldSelector = /*#__PURE__*/(0, _react.memo)(({
  indexPattern,
  valueChange,
  defaultStackByValue = DEFAULT_STACK_BY_VALUE
}) => {
  const styles = (0, _styles.useStyles)();
  const defaultStackByValueInfo = indexPattern.fields.find(f => f.name === defaultStackByValue);
  const [selectedField, setSelectedField] = (0, _react.useState)([{
    label: defaultStackByValue,
    value: defaultStackByValueInfo === null || defaultStackByValueInfo === void 0 ? void 0 : defaultStackByValueInfo.type
  }]);
  const fields = (0, _react.useMemo)(() => indexPattern ? indexPattern.fields.map(f => ({
    label: f.name,
    value: f.type
  })) : [], [indexPattern]);
  const selectedFieldChange = (0, _react.useCallback)(values => {
    if (values && values.length > 0) {
      valueChange(values[0]);
    }
    setSelectedField(values);
  }, [valueChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    css: styles.comboBox,
    "data-test-subj": _test_ids.DROPDOWN_TEST_ID,
    prepend: _translations.COMBOBOX_PREPEND_LABEL,
    singleSelection: COMBOBOX_SINGLE_SELECTION,
    onChange: selectedFieldChange,
    options: fields,
    selectedOptions: selectedField,
    isClearable: false
  });
});
exports.IndicatorsFieldSelector = IndicatorsFieldSelector;