"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndicatorById = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../../../hooks/use_kibana");
var _fetch_indicator_by_id = require("../services/fetch_indicator_by_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_ID = 'indicatorById';
/**
 * Retrieve document from ES by id
 * @param indicatorId id of the indicator saved within the cases attachment
 * @return an object with the indicator and the loading status
 */
const useIndicatorById = indicatorId => {
  const {
    services: {
      data: {
        search: searchService
      }
    }
  } = (0, _use_kibana.useKibana)();
  const fetchIndicatorById = (0, _react.useMemo)(() => (0, _fetch_indicator_by_id.createFetchIndicatorById)({
    searchService
  }), [searchService]);
  const {
    isLoading,
    data: indicator
  } = (0, _reactQuery.useQuery)([QUERY_ID, {
    indicatorId
  }], ({
    signal,
    queryKey: [_key, queryParams]
  }) => fetchIndicatorById(queryParams, signal));
  return {
    indicator,
    isLoading
  };
};
exports.useIndicatorById = useIndicatorById;