"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.IndicatorsPageWrapper = exports.APP_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _indicators = require("../modules/indicators/pages/indicators");
var _integrations_guard = require("./integrations_guard");
var _security_solution_plugin_template_wrapper = require("./security_solution_plugin_template_wrapper");
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APP_ID = 'securitySolution';
exports.APP_ID = APP_ID;
const IndicatorsPageWrapper = () => {
  const {
    cases
  } = (0, _use_kibana.useKibana)().services;
  const CasesContext = cases.ui.getCasesContext();
  const permissions = cases.helpers.canUseCases();
  const queryClient = new _reactQuery.QueryClient();
  return /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: [APP_ID],
    permissions: permissions
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_integrations_guard.IntegrationsGuard, null, /*#__PURE__*/_react.default.createElement(_security_solution_plugin_template_wrapper.SecuritySolutionPluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_indicators.IndicatorsPage, null)))));
};

// Note: This is for lazy loading
// eslint-disable-next-line import/no-default-export
exports.IndicatorsPageWrapper = IndicatorsPageWrapper;
var _default = IndicatorsPageWrapper;
exports.default = _default;