"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrivateLocations = void 0;
var _server = require("@kbn/core/server");
var _private_locations = require("../../common/saved_objects/private_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPrivateLocations = async client => {
  try {
    var _obj$attributes$locat;
    const obj = await client.get(_private_locations.privateLocationsSavedObjectName, _private_locations.privateLocationsSavedObjectId);
    return (_obj$attributes$locat = obj === null || obj === void 0 ? void 0 : obj.attributes.locations) !== null && _obj$attributes$locat !== void 0 ? _obj$attributes$locat : [];
  } catch (getErr) {
    if (_server.SavedObjectsErrorHelpers.isNotFoundError(getErr)) {
      return [];
    }
    throw getErr;
  }
};
exports.getPrivateLocations = getPrivateLocations;