"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syncParamsSyntheticsParamsRoute = void 0;
var _common = require("@kbn/spaces-plugin/common");
var _get_private_locations = require("../../synthetics_service/get_private_locations");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const syncParamsSyntheticsParamsRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.SYNC_GLOBAL_PARAMS,
  validate: {},
  handler: async ({
    savedObjectsClient,
    syntheticsMonitorClient,
    request,
    server
  }) => {
    var _server$spaces$spaces, _server$spaces;
    const spaceId = (_server$spaces$spaces = (_server$spaces = server.spaces) === null || _server$spaces === void 0 ? void 0 : _server$spaces.spacesService.getSpaceId(request)) !== null && _server$spaces$spaces !== void 0 ? _server$spaces$spaces : _common.DEFAULT_SPACE_ID;
    const allPrivateLocations = await (0, _get_private_locations.getPrivateLocations)(savedObjectsClient);
    await syntheticsMonitorClient.syncGlobalParams({
      spaceId,
      allPrivateLocations,
      encryptedSavedObjects: server.encryptedSavedObjects
    });
    return {
      success: true
    };
  }
});
exports.syncParamsSyntheticsParamsRoute = syncParamsSyntheticsParamsRoute;