"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentPolicyAsInternalUser = exports.getAgentPoliciesRoute = exports.getAgentPoliciesAsInternalUser = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAgentPoliciesRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.AGENT_POLICIES,
  validate: {},
  handler: async ({
    server
  }) => {
    return getAgentPoliciesAsInternalUser(server);
  }
});
exports.getAgentPoliciesRoute = getAgentPoliciesRoute;
const getAgentPoliciesAsInternalUser = async server => {
  var _server$fleet;
  const soClient = server.coreStart.savedObjects.createInternalRepository();
  const esClient = server.coreStart.elasticsearch.client.asInternalUser;
  const agentPolicies = await ((_server$fleet = server.fleet) === null || _server$fleet === void 0 ? void 0 : _server$fleet.agentPolicyService.list(soClient, {
    page: 1,
    perPage: 10000,
    sortField: 'name',
    sortOrder: 'asc',
    kuery: 'ingest-agent-policies.is_managed : false',
    esClient,
    withAgentCount: true
  }));
  return agentPolicies.items.map(agentPolicy => {
    var _agentPolicy$agents;
    return {
      id: agentPolicy.id,
      name: agentPolicy.name,
      agents: (_agentPolicy$agents = agentPolicy.agents) !== null && _agentPolicy$agents !== void 0 ? _agentPolicy$agents : 0,
      status: agentPolicy.status,
      description: agentPolicy.description,
      namespace: agentPolicy.namespace
    };
  });
};
exports.getAgentPoliciesAsInternalUser = getAgentPoliciesAsInternalUser;
const getAgentPolicyAsInternalUser = async (server, id) => {
  var _server$fleet2, _agentPolicy$agents2;
  const soClient = server.coreStart.savedObjects.createInternalRepository();
  const agentPolicy = await ((_server$fleet2 = server.fleet) === null || _server$fleet2 === void 0 ? void 0 : _server$fleet2.agentPolicyService.get(soClient, id));
  if (!agentPolicy) {
    return null;
  }
  return {
    id: agentPolicy.id,
    name: agentPolicy.name,
    agents: (_agentPolicy$agents2 = agentPolicy.agents) !== null && _agentPolicy$agents2 !== void 0 ? _agentPolicy$agents2 : 0,
    status: agentPolicy.status,
    description: agentPolicy.description,
    namespace: agentPolicy.namespace
  };
};
exports.getAgentPolicyAsInternalUser = getAgentPolicyAsInternalUser;