"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deletePackagePolicyRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deletePackagePolicyRoute = () => ({
  method: 'DELETE',
  path: _constants.SYNTHETICS_API_URLS.DELETE_PACKAGE_POLICY,
  validate: {
    params: _configSchema.schema.object({
      packagePolicyId: _configSchema.schema.string({
        minLength: 1,
        maxLength: 1024
      })
    })
  },
  handler: async ({
    request,
    savedObjectsClient,
    server,
    uptimeEsClient
  }) => {
    const {
      packagePolicyId
    } = request.params;
    const response = await server.fleet.packagePolicyService.delete(savedObjectsClient, uptimeEsClient.baseESClient, [packagePolicyId], {
      force: true
    });
    if (response !== null && response !== void 0 && response[0].success) {
      return response;
    } else {
      var _response$0$body;
      throw new Error(response === null || response === void 0 ? void 0 : (_response$0$body = response[0].body) === null || _response$0$body === void 0 ? void 0 : _response$0$body.message);
    }
  }
});
exports.deletePackagePolicyRoute = deletePackagePolicyRoute;