"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateDefaultAlertingRoute = void 0;
var _default_alert_service = require("./default_alert_service");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateDefaultAlertingRoute = () => ({
  method: 'PUT',
  path: _constants.SYNTHETICS_API_URLS.ENABLE_DEFAULT_ALERTING,
  validate: {},
  handler: async ({
    context,
    server,
    savedObjectsClient
  }) => {
    const defaultAlertService = new _default_alert_service.DefaultAlertService(context, server, savedObjectsClient);
    const [statusRule, tlsRule] = await Promise.all([defaultAlertService.updateStatusRule(), defaultAlertService.updateTlsRule()]);
    return {
      statusRule,
      tlsRule
    };
  }
});
exports.updateDefaultAlertingRoute = updateDefaultAlertingRoute;