"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSyntheticsStatusCheckRule = void 0;
var _server = require("@kbn/core/server");
var _lodash = require("lodash");
var _common = require("@kbn/observability-plugin/common");
var _server2 = require("@kbn/rule-registry-plugin/server");
var _message_utils = require("./message_utils");
var _status_rule_executor = require("./status_rule_executor");
var _status_rule = require("../../../common/rules/status_rule");
var _synthetics_alerts = require("../../../common/constants/synthetics_alerts");
var _common2 = require("../common");
var _action_variables = require("../action_variables");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSyntheticsStatusCheckRule = (server, plugins, syntheticsMonitorClient, ruleDataClient) => {
  const createLifecycleRuleType = (0, _server2.createLifecycleRuleTypeFactory)({
    ruleDataClient,
    logger: server.logger
  });
  return createLifecycleRuleType({
    id: _synthetics_alerts.SYNTHETICS_ALERT_RULE_TYPES.MONITOR_STATUS,
    category: _server.DEFAULT_APP_CATEGORIES.observability.id,
    producer: 'uptime',
    name: _translations.STATUS_RULE_NAME,
    validate: {
      params: _status_rule.StatusRulePramsSchema
    },
    defaultActionGroupId: _synthetics_alerts.MONITOR_STATUS.id,
    actionGroups: [_synthetics_alerts.MONITOR_STATUS],
    actionVariables: (0, _action_variables.getActionVariables)({
      plugins
    }),
    isExportable: true,
    minimumLicenseRequired: 'basic',
    doesSetRecoveryContext: true,
    async executor({
      state,
      params,
      services,
      spaceId,
      previousStartedAt
    }) {
      var _ruleState$meta;
      const ruleState = state;
      const {
        basePath
      } = server;
      const {
        alertFactory,
        getAlertUuid,
        savedObjectsClient,
        scopedClusterClient,
        alertWithLifecycle,
        uiSettingsClient
      } = services;
      const dateFormat = await uiSettingsClient.get('dateFormat');
      const timezone = await uiSettingsClient.get('dateFormat:tz');
      const tz = timezone === 'Browser' ? 'UTC' : timezone;
      const statusRule = new _status_rule_executor.StatusRuleExecutor(previousStartedAt, params, savedObjectsClient, scopedClusterClient.asCurrentUser, server, syntheticsMonitorClient);
      const {
        downConfigs,
        staleDownConfigs,
        upConfigs
      } = await statusRule.getDownChecks((_ruleState$meta = ruleState.meta) === null || _ruleState$meta === void 0 ? void 0 : _ruleState$meta.downConfigs);
      Object.entries(downConfigs).forEach(([idWithLocation, {
        ping,
        configId
      }]) => {
        var _ping$observer$name;
        const locationId = (_ping$observer$name = ping.observer.name) !== null && _ping$observer$name !== void 0 ? _ping$observer$name : '';
        const alertId = idWithLocation;
        const monitorSummary = (0, _message_utils.getMonitorSummary)(ping, _message_utils.DOWN_LABEL, locationId, configId, dateFormat, tz);
        const alert = alertWithLifecycle({
          id: alertId,
          fields: (0, _message_utils.getMonitorAlertDocument)(monitorSummary)
        });
        const alertUuid = getAlertUuid(alertId);
        const alertState = alert.getState();
        const errorStartedAt = alertState.errorStartedAt || ping['@timestamp'];
        let relativeViewInAppUrl = '';
        if (monitorSummary.stateId) {
          relativeViewInAppUrl = (0, _common2.getRelativeViewInAppUrl)({
            configId,
            stateId: monitorSummary.stateId,
            locationId
          });
        }
        const context = {
          ...monitorSummary,
          errorStartedAt,
          linkMessage: monitorSummary.stateId ? (0, _common2.getFullViewInAppMessage)(basePath, spaceId, relativeViewInAppUrl) : '',
          [_action_variables.VIEW_IN_APP_URL]: (0, _common2.getViewInAppUrl)(basePath, spaceId, relativeViewInAppUrl)
        };
        alert.replaceState({
          ...(0, _common2.updateState)(ruleState, true),
          ...context,
          idWithLocation
        });
        alert.scheduleActions(_synthetics_alerts.MONITOR_STATUS.id, {
          ...context,
          [_action_variables.ALERT_DETAILS_URL]: (0, _common2.getAlertDetailsUrl)(basePath, spaceId, alertUuid)
        });
      });
      (0, _common2.setRecoveredAlertsContext)({
        alertFactory,
        basePath,
        getAlertUuid,
        spaceId,
        staleDownConfigs,
        upConfigs,
        dateFormat,
        tz
      });
      return {
        state: (0, _common2.updateState)(ruleState, !(0, _lodash.isEmpty)(downConfigs), {
          downConfigs
        })
      };
    },
    alerts: _common2.UptimeRuleTypeAlertDefinition,
    getViewInAppRelativeUrl: ({
      rule
    }) => _common.observabilityPaths.ruleDetails(rule.id)
  });
};
exports.registerSyntheticsStatusCheckRule = registerSyntheticsStatusCheckRule;