"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.networkEventsReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {};
const networkEventsReducer = (0, _toolkit.createReducer)(initialState, builder => {
  builder.addCase(_actions.getNetworkEvents.get, (state, action) => {
    const {
      checkGroup,
      stepIndex
    } = action.payload;
    state[checkGroup] = state[checkGroup] ? {
      [stepIndex]: state[checkGroup][stepIndex] ? {
        ...state[checkGroup][stepIndex],
        loading: true,
        events: [],
        total: 0,
        isWaterfallSupported: true
      } : {
        loading: true,
        events: [],
        total: 0,
        isWaterfallSupported: true
      }
    } : {
      [stepIndex]: {
        loading: true,
        events: [],
        total: 0,
        isWaterfallSupported: true
      }
    };
  }).addCase(_actions.getNetworkEvents.success, (state, action) => {
    const {
      events,
      total,
      checkGroup,
      stepIndex,
      isWaterfallSupported,
      hasNavigationRequest
    } = action.payload;
    state[checkGroup] = state[checkGroup] ? {
      [stepIndex]: state[checkGroup][stepIndex] ? {
        ...state[checkGroup][stepIndex],
        loading: false,
        events,
        total,
        isWaterfallSupported,
        hasNavigationRequest
      } : {
        loading: false,
        events,
        total,
        isWaterfallSupported,
        hasNavigationRequest
      }
    } : {
      [stepIndex]: {
        loading: false,
        events,
        total,
        isWaterfallSupported,
        hasNavigationRequest
      }
    };
  }).addCase(_actions.getNetworkEvents.fail, (state, action) => {
    const {
      checkGroup,
      stepIndex,
      error
    } = action.payload;
    state[checkGroup] = state[checkGroup] ? {
      [stepIndex]: state[checkGroup][stepIndex] ? {
        ...state[checkGroup][stepIndex],
        loading: false,
        events: [],
        total: 0,
        error,
        isWaterfallSupported: true
      } : {
        loading: false,
        events: [],
        total: 0,
        error,
        isWaterfallSupported: true
      }
    } : {
      [stepIndex]: {
        loading: false,
        events: [],
        total: 0,
        error,
        isWaterfallSupported: true
      }
    };
  });
});
exports.networkEventsReducer = networkEventsReducer;