"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateMonitorAPI = exports.inspectMonitorAPI = exports.getDecryptedMonitorAPI = exports.fetchProjectAPIKey = exports.deletePackagePolicy = exports.createMonitorAPI = void 0;
var _api_service = require("../../../../utils/api_service");
var _runtime_types = require("../../../../../common/runtime_types");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMonitorAPI = async ({
  monitor
}) => {
  return await _api_service.apiService.post(_constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS, monitor);
};
exports.createMonitorAPI = createMonitorAPI;
const inspectMonitorAPI = async ({
  monitor,
  hideParams
}) => {
  return await _api_service.apiService.post(_constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITOR_INSPECT, monitor, undefined, {
    hideParams
  });
};
exports.inspectMonitorAPI = inspectMonitorAPI;
const updateMonitorAPI = async ({
  monitor,
  id
}) => {
  return await _api_service.apiService.put(`${_constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS}/${id}`, monitor);
};
exports.updateMonitorAPI = updateMonitorAPI;
const getDecryptedMonitorAPI = async ({
  id
}) => _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.GET_SYNTHETICS_MONITOR.replace('{monitorId}', id), {
  decrypted: true
}, _runtime_types.SyntheticsMonitorCodec);
exports.getDecryptedMonitorAPI = getDecryptedMonitorAPI;
const fetchProjectAPIKey = async accessToElasticManagedLocations => {
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.SYNTHETICS_PROJECT_APIKEY, {
    accessToElasticManagedLocations
  });
};
exports.fetchProjectAPIKey = fetchProjectAPIKey;
const deletePackagePolicy = async packagePolicyId => {
  return await _api_service.apiService.delete(_constants.SYNTHETICS_API_URLS.DELETE_PACKAGE_POLICY.replace('{packagePolicyId}', packagePolicyId));
};
exports.deletePackagePolicy = deletePackagePolicy;