"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMonitorListPageStateWithDefaults = getMonitorListPageStateWithDefaults;
var _monitor_management = require("../../../../../common/constants/monitor_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE_STATE = {
  pageIndex: 0,
  pageSize: 10,
  sortOrder: 'asc',
  sortField: `${_monitor_management.ConfigKey.NAME}.keyword`
};
function getMonitorListPageStateWithDefaults(override) {
  return {
    ...DEFAULT_PAGE_STATE,
    ...(override !== null && override !== void 0 ? override : {})
  };
}