"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUrlParams = exports.useGetUrlParams = void 0;
var _react = require("react");
var _queryString = require("query-string");
var _reactRouterDom = require("react-router-dom");
var _url_params = require("../utils/url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getParsedParams(search) {
  return search ? (0, _queryString.parse)(search[0] === '?' ? search.slice(1) : search, {
    sort: false
  }) : {};
}
const useGetUrlParams = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  return (0, _url_params.getSupportedUrlParams)(getParsedParams(search));
};
exports.useGetUrlParams = useGetUrlParams;
const useUrlParams = () => {
  const {
    pathname,
    search
  } = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const updateUrlParams = (0, _react.useCallback)((updatedParams, replaceState = false) => {
    const currentParams = getParsedParams(search);
    const mergedParams = {
      ...currentParams,
      ...updatedParams
    };
    const urlKeys = Object.keys(mergedParams);
    const updatedSearch = updatedParams ? (0, _queryString.stringify)(
    // drop any parameters that have no value
    urlKeys.reduce((params, key) => {
      const value = mergedParams[key];
      if (value === undefined || value === '') {
        return params;
      }
      return {
        ...params,
        [key]: value
      };
    }, {})) : null;

    // only update the URL if the search has actually changed
    if (search !== updatedSearch) {
      if (replaceState) {
        history.replace({
          pathname,
          search: updatedSearch || undefined
        });
      } else {
        history.push({
          pathname,
          search: updatedSearch || undefined
        });
      }
    }
  }, [history, pathname, search]);
  return [useGetUrlParams, updateUrlParams];
};
exports.useUrlParams = useUrlParams;