"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTestRunDetailsBreadcrumbs = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_selected_location = require("../../monitor_details/hooks/use_selected_location");
var _use_selected_monitor = require("../../monitor_details/hooks/use_selected_monitor");
var _use_breadcrumbs = require("../../../hooks/use_breadcrumbs");
var _runtime_types = require("../../../../../../common/runtime_types");
var _constants = require("../../../../../../common/constants");
var _plugin = require("../../../../../../common/constants/plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTestRunDetailsBreadcrumbs = extraCrumbs => {
  var _kibana$services$appl, _kibana$services$appl2, _monitor$name, _monitor$ConfigKey$CO, _selectedLocation$id;
  const kibana = (0, _public.useKibana)();
  const appPath = (_kibana$services$appl = (_kibana$services$appl2 = kibana.services.application) === null || _kibana$services$appl2 === void 0 ? void 0 : _kibana$services$appl2.getUrlForApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID)) !== null && _kibana$services$appl !== void 0 ? _kibana$services$appl : '';
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    text: MONITOR_MANAGEMENT_CRUMB,
    href: `${appPath}${_constants.MONITORS_ROUTE}`
  }, ...(monitor ? [{
    text: (_monitor$name = monitor === null || monitor === void 0 ? void 0 : monitor.name) !== null && _monitor$name !== void 0 ? _monitor$name : '',
    href: `${appPath}${_constants.MONITOR_ROUTE.replace(':monitorId', (_monitor$ConfigKey$CO = monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.CONFIG_ID]) !== null && _monitor$ConfigKey$CO !== void 0 ? _monitor$ConfigKey$CO : '')}?locationId=${(_selectedLocation$id = selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id) !== null && _selectedLocation$id !== void 0 ? _selectedLocation$id : ''}`
  }] : []), ...(extraCrumbs !== null && extraCrumbs !== void 0 ? extraCrumbs : [])]);
};
exports.useTestRunDetailsBreadcrumbs = useTestRunDetailsBreadcrumbs;
const MONITOR_MANAGEMENT_CRUMB = _i18n.i18n.translate('xpack.synthetics.monitorsPage.monitorsMCrumb', {
  defaultMessage: 'Monitors'
});