"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepNumberNav = exports.PREVIOUS_STEP_BUTTON_TEXT = exports.NEXT_STEP_BUTTON_TEXT = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepNumberNav = ({
  stepIndex,
  totalSteps,
  handleNextStep,
  handlePreviousStep
}) => {
  const hasPreviousStep = stepIndex > 1;
  const hasNextStep = stepIndex < totalSteps;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepNumberNavButton",
    onClick: handlePreviousStep,
    disabled: !hasPreviousStep,
    iconType: "arrowLeft"
  }, PREVIOUS_STEP_BUTTON_TEXT)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.testDetails.stepNav",
    defaultMessage: "{stepIndex} / {totalSteps}",
    values: {
      stepIndex,
      totalSteps
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepNumberNavButton",
    onClick: handleNextStep,
    disabled: !hasNextStep,
    iconType: "arrowRight",
    iconSide: "right"
  }, NEXT_STEP_BUTTON_TEXT)))));
};
exports.StepNumberNav = StepNumberNav;
const PREVIOUS_STEP_BUTTON_TEXT = _i18n.i18n.translate('xpack.synthetics.synthetics.stepDetail.previousStepButtonText', {
  defaultMessage: 'Previous'
});
exports.PREVIOUS_STEP_BUTTON_TEXT = PREVIOUS_STEP_BUTTON_TEXT;
const NEXT_STEP_BUTTON_TEXT = _i18n.i18n.translate('xpack.synthetics.synthetics.stepDetail.nextStepButtonText', {
  defaultMessage: 'Next'
});
exports.NEXT_STEP_BUTTON_TEXT = NEXT_STEP_BUTTON_TEXT;