"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRANSFER_SIZE_HELP = exports.LCP_LABEL = exports.LCP_HELP_LABEL = exports.FCP_TOOLTIP = exports.FCP_LABEL = exports.DCL_TOOLTIP = exports.DCL_LABEL = exports.CLS_LABEL = exports.CLS_HELP_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LCP_HELP_LABEL = _i18n.i18n.translate('xpack.synthetics.coreVitals.lcp.help', {
  defaultMessage: 'Largest contentful paint measures loading performance. To provide a good user experience, LCP should occur within 2.5 seconds of when the page first starts loading.'
});
exports.LCP_HELP_LABEL = LCP_HELP_LABEL;
const CLS_HELP_LABEL = _i18n.i18n.translate('xpack.synthetics.coreVitals.cls.help', {
  defaultMessage: 'Cumulative Layout Shift (CLS): measures visual stability. To provide a good user experience, pages should maintain a CLS of less than 0.1.'
});
exports.CLS_HELP_LABEL = CLS_HELP_LABEL;
const FCP_TOOLTIP = _i18n.i18n.translate('xpack.synthetics.coreVitals.fcpTooltip', {
  defaultMessage: 'First contentful paint (FCP) focuses on the initial rendering and measures the time from when the page starts loading to when any part of the page’s content is displayed on the screen.'
});
exports.FCP_TOOLTIP = FCP_TOOLTIP;
const DCL_TOOLTIP = _i18n.i18n.translate('xpack.synthetics.coreVitals.dclTooltip', {
  defaultMessage: 'Triggered when the browser completes parsing the document. Helpful when there are multiple listeners, or logic is executed: domContentLoadedEventEnd - domContentLoadedEventStart.'
});
exports.DCL_TOOLTIP = DCL_TOOLTIP;
const TRANSFER_SIZE_HELP = _i18n.i18n.translate('xpack.synthetics.fieldLabels.transferSize', {
  defaultMessage: 'The transferSize property represents the size of the fetched resource. The size includes the response header fields plus the response payload body'
});
exports.TRANSFER_SIZE_HELP = TRANSFER_SIZE_HELP;
const LCP_LABEL = _i18n.i18n.translate('xpack.synthetics.fieldLabels.lcp', {
  defaultMessage: 'Largest contentful paint (LCP)'
});
exports.LCP_LABEL = LCP_LABEL;
const FCP_LABEL = _i18n.i18n.translate('xpack.synthetics.fieldLabels.fcp', {
  defaultMessage: 'First contentful paint (FCP)'
});
exports.FCP_LABEL = FCP_LABEL;
const CLS_LABEL = _i18n.i18n.translate('xpack.synthetics.fieldLabels.cls', {
  defaultMessage: 'Cumulative layout shift (CLS)'
});
exports.CLS_LABEL = CLS_LABEL;
const DCL_LABEL = _i18n.i18n.translate('xpack.synthetics.fieldLabels.dcl', {
  defaultMessage: 'DOMContentLoaded event (DCL)'
});
exports.DCL_LABEL = DCL_LABEL;