"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepFilters = exports.useNetworkTimings = exports.getTimingWithLabels = exports.SYNTHETICS_WAIT_TIMINGS_LABEL = exports.SYNTHETICS_TLS_TIMINGS_LABEL = exports.SYNTHETICS_SEND_TIMINGS_LABEL = exports.SYNTHETICS_RECEIVE_TIMINGS_LABEL = exports.SYNTHETICS_DNS_TIMINGS_LABEL = exports.SYNTHETICS_CONNECT_TIMINGS_LABEL = exports.SYNTHETICS_BLOCKED_TIMINGS_LABEL = void 0;
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-shared-plugin/common");
var _constants = require("../../../../../../common/constants");
var _use_redux_es_search = require("../../../hooks/use_redux_es_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStepFilters = (checkGroupId, stepIndex) => {
  return [{
    term: {
      'monitor.check_group': checkGroupId
    }
  }, {
    term: {
      'synthetics.step.index': stepIndex
    }
  }];
};
exports.useStepFilters = useStepFilters;
const useNetworkTimings = (checkGroupIdArg, stepIndexArg) => {
  var _aggs$dns$value, _aggs$connect$value, _aggs$receive$value, _aggs$send$value, _aggs$wait$value, _aggs$blocked$value, _aggs$tls$value;
  const params = (0, _reactRouterDom.useParams)();
  const checkGroupId = checkGroupIdArg !== null && checkGroupIdArg !== void 0 ? checkGroupIdArg : params.checkGroupId;
  const stepIndex = stepIndexArg !== null && stepIndexArg !== void 0 ? stepIndexArg : Number(params.stepIndex);
  const runTimeMappings = _common.NETWORK_TIMINGS_FIELDS.reduce((acc, field) => ({
    ...acc,
    [field]: {
      type: 'double'
    }
  }), {});
  const {
    data
  } = (0, _use_redux_es_search.useReduxEsSearch)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    body: {
      size: 0,
      runtime_mappings: runTimeMappings,
      query: {
        bool: {
          filter: [{
            term: {
              'synthetics.type': 'journey/network_info'
            }
          }, ...useStepFilters(checkGroupId, stepIndex)]
        }
      },
      aggs: {
        dns: {
          sum: {
            field: _common.SYNTHETICS_DNS_TIMINGS
          }
        },
        tls: {
          sum: {
            field: _common.SYNTHETICS_SSL_TIMINGS
          }
        },
        blocked: {
          sum: {
            field: _common.SYNTHETICS_BLOCKED_TIMINGS
          }
        },
        connect: {
          sum: {
            field: _common.SYNTHETICS_CONNECT_TIMINGS
          }
        },
        receive: {
          sum: {
            field: _common.SYNTHETICS_RECEIVE_TIMINGS
          }
        },
        send: {
          sum: {
            field: _common.SYNTHETICS_SEND_TIMINGS
          }
        },
        wait: {
          sum: {
            field: _common.SYNTHETICS_WAIT_TIMINGS
          }
        },
        total: {
          sum: {
            field: _common.SYNTHETICS_TOTAL_TIMINGS
          }
        }
      }
    }
  }, [], {
    name: `stepNetworkTimingsMetrics/${checkGroupId}/${stepIndex}`
  });
  const aggs = data === null || data === void 0 ? void 0 : data.aggregations;
  const timings = {
    dns: (_aggs$dns$value = aggs === null || aggs === void 0 ? void 0 : aggs.dns.value) !== null && _aggs$dns$value !== void 0 ? _aggs$dns$value : 0,
    connect: (_aggs$connect$value = aggs === null || aggs === void 0 ? void 0 : aggs.connect.value) !== null && _aggs$connect$value !== void 0 ? _aggs$connect$value : 0,
    receive: (_aggs$receive$value = aggs === null || aggs === void 0 ? void 0 : aggs.receive.value) !== null && _aggs$receive$value !== void 0 ? _aggs$receive$value : 0,
    send: (_aggs$send$value = aggs === null || aggs === void 0 ? void 0 : aggs.send.value) !== null && _aggs$send$value !== void 0 ? _aggs$send$value : 0,
    wait: (_aggs$wait$value = aggs === null || aggs === void 0 ? void 0 : aggs.wait.value) !== null && _aggs$wait$value !== void 0 ? _aggs$wait$value : 0,
    blocked: (_aggs$blocked$value = aggs === null || aggs === void 0 ? void 0 : aggs.blocked.value) !== null && _aggs$blocked$value !== void 0 ? _aggs$blocked$value : 0,
    tls: (_aggs$tls$value = aggs === null || aggs === void 0 ? void 0 : aggs.tls.value) !== null && _aggs$tls$value !== void 0 ? _aggs$tls$value : 0
  };
  return {
    timings,
    timingsWithLabels: getTimingWithLabels(timings)
  };
};
exports.useNetworkTimings = useNetworkTimings;
const getTimingWithLabels = timings => {
  return [{
    value: timings.blocked,
    label: SYNTHETICS_BLOCKED_TIMINGS_LABEL
  }, {
    value: timings.dns,
    label: SYNTHETICS_DNS_TIMINGS_LABEL
  }, {
    value: timings.connect,
    label: SYNTHETICS_CONNECT_TIMINGS_LABEL
  }, {
    value: timings.tls,
    label: SYNTHETICS_TLS_TIMINGS_LABEL
  }, {
    value: timings.wait,
    label: SYNTHETICS_WAIT_TIMINGS_LABEL
  }, {
    value: timings.receive,
    label: SYNTHETICS_RECEIVE_TIMINGS_LABEL
  }, {
    value: timings.send,
    label: SYNTHETICS_SEND_TIMINGS_LABEL
  }];
};
exports.getTimingWithLabels = getTimingWithLabels;
const SYNTHETICS_CONNECT_TIMINGS_LABEL = _i18n.i18n.translate('xpack.synthetics.connect.label', {
  defaultMessage: 'Connect'
});
exports.SYNTHETICS_CONNECT_TIMINGS_LABEL = SYNTHETICS_CONNECT_TIMINGS_LABEL;
const SYNTHETICS_DNS_TIMINGS_LABEL = _i18n.i18n.translate('xpack.synthetics.dns', {
  defaultMessage: 'DNS'
});
exports.SYNTHETICS_DNS_TIMINGS_LABEL = SYNTHETICS_DNS_TIMINGS_LABEL;
const SYNTHETICS_WAIT_TIMINGS_LABEL = _i18n.i18n.translate('xpack.synthetics.wait', {
  defaultMessage: 'Wait'
});
exports.SYNTHETICS_WAIT_TIMINGS_LABEL = SYNTHETICS_WAIT_TIMINGS_LABEL;
const SYNTHETICS_TLS_TIMINGS_LABEL = _i18n.i18n.translate('xpack.synthetics.tls', {
  defaultMessage: 'TLS'
});
exports.SYNTHETICS_TLS_TIMINGS_LABEL = SYNTHETICS_TLS_TIMINGS_LABEL;
const SYNTHETICS_BLOCKED_TIMINGS_LABEL = _i18n.i18n.translate('xpack.synthetics.blocked', {
  defaultMessage: 'Blocked'
});
exports.SYNTHETICS_BLOCKED_TIMINGS_LABEL = SYNTHETICS_BLOCKED_TIMINGS_LABEL;
const SYNTHETICS_SEND_TIMINGS_LABEL = _i18n.i18n.translate('xpack.synthetics.send', {
  defaultMessage: 'Send'
});
exports.SYNTHETICS_SEND_TIMINGS_LABEL = SYNTHETICS_SEND_TIMINGS_LABEL;
const SYNTHETICS_RECEIVE_TIMINGS_LABEL = _i18n.i18n.translate('xpack.synthetics.receive', {
  defaultMessage: 'Receive'
});
exports.SYNTHETICS_RECEIVE_TIMINGS_LABEL = SYNTHETICS_RECEIVE_TIMINGS_LABEL;