"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteLocation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _contexts = require("../../../contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteLocation = ({
  loading,
  id,
  label,
  locationMonitors,
  onDelete
}) => {
  var _locationMonitors$fin, _locationMonitors$fin2;
  const monCount = (_locationMonitors$fin = locationMonitors === null || locationMonitors === void 0 ? void 0 : (_locationMonitors$fin2 = locationMonitors.find(l => l.id === id)) === null || _locationMonitors$fin2 === void 0 ? void 0 : _locationMonitors$fin2.count) !== null && _locationMonitors$fin !== void 0 ? _locationMonitors$fin : 0;
  const canDelete = monCount === 0;
  const {
    canSave
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const deleteDisabledReason = _i18n.i18n.translate('xpack.synthetics.monitorManagement.cannotDelete.description', {
    defaultMessage: `You can't delete this location because it is used in {monCount, number} {monCount, plural,one {monitor} other {monitors}}.
                Remove this location from all monitors first.`,
    values: {
      monCount
    }
  });
  const deleteModal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.synthetics.monitorManagement.deleteLocationName', {
      defaultMessage: 'Delete "{location}"',
      values: {
        location: label
      }
    }),
    onCancel: () => setIsModalOpen(false),
    onConfirm: () => onDelete(id),
    cancelButtonText: CANCEL_LABEL,
    confirmButtonText: CONFIRM_LABEL,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    isLoading: loading
  }, /*#__PURE__*/_react.default.createElement("p", null, ARE_YOU_SURE_LABEL));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isModalOpen && deleteModal, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: canDelete ? DELETE_LABEL : deleteDisabledReason
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `deleteLocation-${id}`,
    isLoading: loading,
    iconType: "trash",
    color: "danger",
    "aria-label": DELETE_LABEL,
    onClick: () => {
      setIsModalOpen(true);
    },
    isDisabled: !canDelete || !canSave
  })));
};
exports.DeleteLocation = DeleteLocation;
const DELETE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.deleteLocation', {
  defaultMessage: 'Delete location'
});
const CONFIRM_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.deleteLocationLabel', {
  defaultMessage: 'Delete location'
});
const CANCEL_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.cancelLabel', {
  defaultMessage: 'Cancel'
});
const ARE_YOU_SURE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.areYouSure', {
  defaultMessage: 'Are you sure you want to delete this location?'
});