"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteParam = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _global_params = require("../../../state/global_params");
var _settings = require("../../../state/settings");
var _kibana_service = require("../../../../../utils/kibana_service");
var _labels = require("../../monitors_page/management/monitor_list_table/labels");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteParam = ({
  items,
  setIsDeleteModalVisible
}) => {
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const dispatch = (0, _reactRedux.useDispatch)();
  const handleConfirmDelete = () => {
    setIsDeleting(true);
  };
  const {
    status
  } = (0, _public.useFetcher)(() => {
    if (isDeleting) {
      return (0, _global_params.deleteGlobalParams)(items.map(({
        id
      }) => id));
    }
  }, [items, isDeleting]);
  const name = items.map(({
    key
  }) => key).join(', ').slice(0, 50);
  (0, _react.useEffect)(() => {
    if (!isDeleting) {
      return;
    }
    if (status === _public.FETCH_STATUS.FAILURE) {
      _kibana_service.kibanaService.toasts.addDanger({
        title: (0, _public2.toMountPoint)( /*#__PURE__*/_react.default.createElement("p", {
          "data-test-subj": "uptimeDeleteParamFailure"
        }, ' ', _i18n.i18n.translate('xpack.synthetics.paramManagement.paramDeleteFailuresMessage.name', {
          defaultMessage: 'Param {name} failed to delete.',
          values: {
            name
          }
        })))
      }, {
        toastLifeTimeMs: 3000
      });
    } else if (status === _public.FETCH_STATUS.SUCCESS) {
      _kibana_service.kibanaService.toasts.addSuccess({
        title: (0, _public2.toMountPoint)( /*#__PURE__*/_react.default.createElement("p", {
          "data-test-subj": "uptimeDeleteParamSuccess"
        }, _i18n.i18n.translate('xpack.synthetics.paramManagement.paramDeleteSuccessMessage.name', {
          defaultMessage: 'Param {name} deleted successfully.',
          values: {
            name
          }
        })))
      }, {
        toastLifeTimeMs: 3000
      });
      dispatch(_settings.syncGlobalParamsAction.get());
    }
    if (status === _public.FETCH_STATUS.SUCCESS || status === _public.FETCH_STATUS.FAILURE) {
      setIsDeleting(false);
      setIsDeleteModalVisible(false);
      dispatch(_global_params.getGlobalParamAction.get());
      dispatch(_settings.syncGlobalParamsAction.get());
    }
  }, [setIsDeleting, isDeleting, status, setIsDeleteModalVisible, name, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.synthetics.paramManagement.deleteParamNameLabel', {
      defaultMessage: 'Delete "{name}" param?',
      values: {
        name
      }
    }),
    onCancel: () => setIsDeleteModalVisible(false),
    onConfirm: handleConfirmDelete,
    cancelButtonText: _labels.NO_LABEL,
    confirmButtonText: _labels.YES_LABEL,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    isLoading: isDeleting
  });
};
exports.DeleteParam = DeleteParam;