"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortMenu = exports.ORDER_BY_TITLE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SortMenu = ({
  sortOptions,
  orderOptions,
  sortField
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const singleContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'singleContextMenuPopover'
  });
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsSortMenuButton",
    size: "xs",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onButtonClick
  }, sortField);
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    key: "sort_by_title"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, SORT_BY_TITLE))), ...sortOptions.map(option => /*#__PURE__*/_react.default.createElement(ContextMenuItem, {
    option: option,
    onClosePopover: closePopover,
    key: option.value
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    key: "hr",
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    key: "order_by_title"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, ORDER_BY_TITLE))), ...orderOptions.map(option => /*#__PURE__*/_react.default.createElement(ContextMenuItem, {
    option: option,
    onClosePopover: closePopover,
    key: option.value
  }))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: singleContextMenuPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items,
    style: {
      minWidth: 160
    }
  }));
};
exports.SortMenu = SortMenu;
const ContextMenuItem = ({
  option,
  onClosePopover
}) => {
  const getIconType = checked => {
    return checked ? 'check' : 'empty';
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    size: "s",
    key: option.value,
    icon: getIconType(option.checked),
    onClick: () => {
      onClosePopover();
      option.onClick();
    }
    // style={{
    //   marginRight: 24,
    // }}
  }, option.label);
};
const SORT_BY_TITLE = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.sortBy.title', {
  defaultMessage: 'Sort by'
});
const ORDER_BY_TITLE = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.orderBy.title', {
  defaultMessage: 'Order'
});
exports.ORDER_BY_TITLE = ORDER_BY_TITLE;