"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyStateError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyStateError = ({
  errors
}) => {
  const unauthorized = errors.find(error => {
    var _error$body;
    return (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) && error.body.message.includes('unauthorized');
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "securityApp",
    iconColor: "subdued",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, unauthorized ? /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.synthetics.emptyStateError.notAuthorized', {
      defaultMessage: 'You are not authorized to view Uptime data, please contact your system administrator.'
    })) : /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.synthetics.emptyStateError.title', {
      defaultMessage: 'Error'
    }))),
    body: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, !unauthorized && errors.map(error => {
      var _error$body2, _error$body3;
      return /*#__PURE__*/_react.default.createElement("p", {
        key: (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message
      }, (_error$body3 = error.body) === null || _error$body3 === void 0 ? void 0 : _error$body3.message);
    }))
  }))));
};
exports.EmptyStateError = EmptyStateError;