"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorLocations = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _location_status_badges = require("../../../common/components/location_status_badges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorLocations = ({
  locations,
  monitorId,
  overviewStatus
}) => {
  const {
    eui: {
      euiColorVis9,
      euiColorVis0,
      euiColorDisabled
    }
  } = (0, _public.useTheme)();
  const locationsToDisplay = locations.map(loc => {
    var _loc$label;
    const locById = `${monitorId}-${loc.id}`;
    let status = 'unknown';
    let color = euiColorDisabled;
    if (overviewStatus !== null && overviewStatus !== void 0 && overviewStatus.downConfigs[locById]) {
      status = 'down';
      color = euiColorVis9;
    } else if (overviewStatus !== null && overviewStatus !== void 0 && overviewStatus.upConfigs[locById]) {
      status = 'up';
      color = euiColorVis0;
    }
    return {
      id: loc.id,
      label: (_loc$label = loc.label) !== null && _loc$label !== void 0 ? _loc$label : loc.id,
      status,
      color
    };
  });
  return /*#__PURE__*/_react.default.createElement(_location_status_badges.LocationStatusBadges, {
    configId: monitorId,
    locations: locationsToDisplay,
    loading: false
  });
};
exports.MonitorLocations = MonitorLocations;