"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorEnabled = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _use_capabilities = require("../../../../../../hooks/use_capabilities");
var _hooks = require("../../../../hooks");
var _permissions = require("../../../common/components/permissions");
var labels = _interopRequireWildcard(require("./labels"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorEnabled = ({
  configId,
  monitor,
  reloadPage,
  initialLoading = false,
  isSwitchable = true
}) => {
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  const canUsePublicLocations = (0, _use_capabilities.useCanUsePublicLocations)(monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.LOCATIONS]);
  const monitorName = monitor[_runtime_types.ConfigKey.NAME];
  const statusLabels = (0, _react.useMemo)(() => {
    return {
      failureLabel: labels.getMonitorEnabledUpdateFailureMessage(monitorName),
      enabledSuccessLabel: labels.getMonitorEnabledSuccessLabel(monitorName),
      disabledSuccessLabel: labels.getMonitorDisabledSuccessLabel(monitorName)
    };
  }, [monitorName]);
  const {
    isEnabled,
    updateMonitorEnabledState,
    status
  } = (0, _hooks.useMonitorEnableHandler)({
    configId,
    isEnabled: monitor[_runtime_types.ConfigKey.ENABLED],
    reloadPage,
    labels: statusLabels
  });
  const enabled = isEnabled !== null && isEnabled !== void 0 ? isEnabled : monitor[_runtime_types.ConfigKey.ENABLED];
  const isLoading = status === _public.FETCH_STATUS.LOADING;
  const handleEnabledChange = event => {
    const checked = event.target.checked;
    updateMonitorEnabledState(checked);
  };
  const enabledDisableLabel = enabled ? labels.DISABLE_MONITOR_LABEL : labels.ENABLE_MONITOR_LABEL;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading || initialLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }) : /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
    canEditSynthetics: canEditSynthetics,
    canUsePublicLocations: canUsePublicLocations
  }, /*#__PURE__*/_react.default.createElement(SwitchWithCursor, {
    compressed: true,
    checked: enabled,
    disabled: isLoading || !canEditSynthetics || !canUsePublicLocations,
    showLabel: false,
    label: enabledDisableLabel,
    title: enabledDisableLabel,
    "data-test-subj": "syntheticsIsMonitorEnabled",
    "data-is-switchable": isSwitchable,
    onChange: handleEnabledChange
  })));
};

// data-* is the DOM compatible prop format
exports.MonitorEnabled = MonitorEnabled;
const SwitchWithCursor = (0, _common.euiStyled)(_eui.EuiSwitch)`
  & > button {
    cursor: ${({
  'data-is-switchable': isSwitchable
}) => isSwitchable ? undefined : 'not-allowed'};
  }
`;