"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCanUsePublicLocById = void 0;
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCanUsePublicLocById = configId => {
  var _useKibana$services$a, _useKibana$services, _useKibana$services$a2;
  const {
    data: {
      monitors
    }
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const hasManagedLocation = monitors === null || monitors === void 0 ? void 0 : monitors.filter(mon => mon.configId === configId && mon.location.isServiceManaged);
  const canUsePublicLocations = (_useKibana$services$a = (_useKibana$services = (0, _public.useKibana)().services) === null || _useKibana$services === void 0 ? void 0 : (_useKibana$services$a2 = _useKibana$services.application) === null || _useKibana$services$a2 === void 0 ? void 0 : _useKibana$services$a2.capabilities.uptime.elasticManagedLocationsEnabled) !== null && _useKibana$services$a !== void 0 ? _useKibana$services$a : true;
  return hasManagedLocation ? !!canUsePublicLocations : true;
};
exports.useCanUsePublicLocById = useCanUsePublicLocById;