"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_test_flyout_open = require("../../test_now_mode/hooks/use_test_flyout_open");
var _use_monitor_details_page = require("../use_monitor_details_page");
var _use_monitor_range_from = require("../hooks/use_monitor_range_from");
var _monitor_alerts = require("./monitor_alerts");
var _monitor_error_sparklines = require("./monitor_error_sparklines");
var _monitor_status_panel = require("../monitor_status/monitor_status_panel");
var _duration_sparklines = require("./duration_sparklines");
var _duration_trend = require("./duration_trend");
var _step_duration_panel = require("./step_duration_panel");
var _availability_panel = require("./availability_panel");
var _duration_panel = require("./duration_panel");
var _monitor_details_panel_container = require("./monitor_details_panel_container");
var _availability_sparklines = require("./availability_sparklines");
var _last_test_run = require("./last_test_run");
var _test_runs_table = require("./test_runs_table");
var _monitor_errors_count = require("./monitor_errors_count");
var _monitor_pending_wrapper = require("../monitor_pending_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorSummary = () => {
  const {
    from,
    to
  } = (0, _use_monitor_range_from.useMonitorRangeFrom)();
  const isFlyoutOpen = !!(0, _use_test_flyout_open.useTestFlyoutOpen)();
  const dateLabel = from === 'now-30d/d' ? LAST_30_DAYS_LABEL : TO_DATE_LABEL;
  const redirect = (0, _use_monitor_details_page.useMonitorDetailsPage)();
  if (redirect) {
    return redirect;
  }
  return /*#__PURE__*/_react.default.createElement(_monitor_pending_wrapper.MonitorPendingWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    wrap: true,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    css: {
      flexBasis: '36%',
      minWidth: 260
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_details_panel_container.MonitorDetailsPanelContainer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    css: {
      flexBasis: '60%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    grow: false,
    hasBorder: true,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, SUMMARY_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, dateLabel))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: false,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_availability_panel.AvailabilityPanel, {
    from: from,
    to: to,
    id: "availabilityPercentageSummary"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: 100
    }
  }, /*#__PURE__*/_react.default.createElement(_availability_sparklines.AvailabilitySparklines, {
    from: from,
    to: to,
    id: "availabilitySparklineSummary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: false,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 86
    }
  }, /*#__PURE__*/_react.default.createElement(_duration_panel.DurationPanel, {
    from: from,
    to: to,
    id: "durationAvgValueSummary"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: 100
    }
  }, /*#__PURE__*/_react.default.createElement(_duration_sparklines.DurationSparklines, {
    from: from,
    to: to,
    id: "durationAvgSparklineSummary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: false,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_monitor_errors_count.MonitorErrorsCount, {
    from: from,
    to: to,
    id: "monitorErrorsCountSummary"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: 100
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_error_sparklines.MonitorErrorSparklines, {
    from: from,
    to: to,
    id: "monitorErrorsSparklineSummary"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "m",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, DURATION_TREND_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, dateLabel))), /*#__PURE__*/_react.default.createElement(_duration_trend.MonitorDurationTrend, {
    from: from,
    to: to
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_monitor_status_panel.MonitorStatusPanel, {
    from: 'now-24h',
    to: 'now',
    brushable: false,
    showViewHistoryButton: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: isFlyoutOpen ? {
      minWidth: 260
    } : undefined
  }, /*#__PURE__*/_react.default.createElement(_last_test_run.LastTestRun, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: 260
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_alerts.MonitorAlerts, {
    dateLabel: dateLabel,
    from: from,
    to: to
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_step_duration_panel.StepDurationPanel, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.LoadWhenInView, {
    placeholderTitle: _test_runs_table.LAST_10_TEST_RUNS
  }, /*#__PURE__*/_react.default.createElement(_test_runs_table.TestRunsTable, {
    paginable: false,
    from: from,
    to: to
  })));
};
exports.MonitorSummary = MonitorSummary;
const SUMMARY_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.summary', {
  defaultMessage: 'Summary'
});
const TO_DATE_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.toDate', {
  defaultMessage: 'To date'
});
const DURATION_TREND_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.durationTrends', {
  defaultMessage: 'Duration trends'
});
const LAST_30_DAYS_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.last30Days', {
  defaultMessage: 'Last 30 days'
});