"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorPendingWrapper = exports.MONITOR_PENDING_HEADING = exports.MONITOR_PENDING_CONTENT = exports.LOADING_TITLE = exports.LOADING_DESCRIPTION = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _page_loader = require("../common/components/page_loader");
var _state = require("../../state");
var _use_monitor_latest_ping = require("./hooks/use_monitor_latest_ping");
var _contexts = require("../../contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorPendingWrapper = ({
  children
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const currentLocation = (0, _reactRouterDom.useLocation)();
  const locationRef = (0, _react.useRef)(currentLocation);
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    refreshApp
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    latestPing,
    loaded: pingsLoaded
  } = (0, _use_monitor_latest_ping.useMonitorLatestPing)();
  const [loaded, setLoaded] = (0, _react.useState)(false);
  const [hasPing, setHasPing] = (0, _react.useState)(false);
  const unlisten = (0, _react.useMemo)(() => history.listen(location => {
    const currentMonitorId = location.pathname.split('/')[2] || '';
    const hasDifferentSearch = locationRef.current.search !== location.search;
    const hasDifferentId = currentMonitorId !== monitorId;
    locationRef.current = location;
    if (hasDifferentSearch || hasDifferentId) {
      setLoaded(false);
      setHasPing(false);
      dispatch((0, _state.resetMonitorLastRunAction)());
      refreshApp();
    }
  }), [history, monitorId, dispatch, refreshApp]);
  (0, _react.useEffect)(() => {
    return function cleanup() {
      unlisten();
    };
  }, [unlisten]);
  (0, _react.useEffect)(() => {
    if (pingsLoaded) {
      setLoaded(true);
    }
    if (pingsLoaded && latestPing) {
      setHasPing(true);
    }
  }, [pingsLoaded, latestPing, dispatch, unlisten]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !loaded ? /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl"
    }),
    title: /*#__PURE__*/_react.default.createElement("h3", null, LOADING_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, LOADING_DESCRIPTION)
  }) : null, loaded && !hasPing ? /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "xl",
      mono: true
    }),
    title: /*#__PURE__*/_react.default.createElement("h3", null, MONITOR_PENDING_HEADING),
    body: /*#__PURE__*/_react.default.createElement("p", null, MONITOR_PENDING_CONTENT)
  }) : null, /*#__PURE__*/_react.default.createElement("div", {
    style: loaded && hasPing ? undefined : {
      display: 'none'
    },
    "data-test-subj": "syntheticsPendingWrapperChildren"
  }, children));
};
exports.MonitorPendingWrapper = MonitorPendingWrapper;
const MONITOR_PENDING_HEADING = _i18n.i18n.translate('xpack.synthetics.monitorDetails.pending.heading', {
  defaultMessage: 'Initial test run pending...'
});
exports.MONITOR_PENDING_HEADING = MONITOR_PENDING_HEADING;
const MONITOR_PENDING_CONTENT = _i18n.i18n.translate('xpack.synthetics.monitorDetails.pending.content', {
  defaultMessage: 'This page will refresh when data becomes available.'
});
exports.MONITOR_PENDING_CONTENT = MONITOR_PENDING_CONTENT;
const LOADING_DESCRIPTION = _i18n.i18n.translate('xpack.synthetics.monitorDetails.loading.content', {
  defaultMessage: 'This will take just a second.'
});
exports.LOADING_DESCRIPTION = LOADING_DESCRIPTION;
const LOADING_TITLE = _i18n.i18n.translate('xpack.synthetics.monitorDetails.loading.heading', {
  defaultMessage: 'Loading monitor details'
});
exports.LOADING_TITLE = LOADING_TITLE;