"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSelectedLocation = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _use_selected_monitor = require("./use_selected_monitor");
var _state = require("../../../state");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSelectedLocation = (updateUrl = true) => {
  const [getUrlParams, updateUrlParams] = (0, _hooks.useUrlParams)();
  const {
    locations
  } = (0, _hooks.useLocations)();
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const selectedLocationId = (0, _reactRedux.useSelector)(_state.selectSelectedLocationId);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    locationId: urlLocationId
  } = getUrlParams();
  (0, _react.useEffect)(() => {
    if (!urlLocationId) {
      var _monitor$locations, _monitor$locations$;
      const monitorLocationId = monitor === null || monitor === void 0 ? void 0 : (_monitor$locations = monitor.locations) === null || _monitor$locations === void 0 ? void 0 : (_monitor$locations$ = _monitor$locations[0]) === null || _monitor$locations$ === void 0 ? void 0 : _monitor$locations$.id;
      if (monitorLocationId && updateUrl) {
        updateUrlParams({
          locationId: monitorLocationId
        }, true);
      }
    }
    if (urlLocationId && selectedLocationId !== urlLocationId) {
      dispatch((0, _state.setMonitorDetailsLocationAction)(urlLocationId));
    }
  }, [dispatch, updateUrlParams, locations, urlLocationId, selectedLocationId, updateUrl, monitor === null || monitor === void 0 ? void 0 : monitor.locations]);
  return (0, _react.useMemo)(() => {
    var _locations$find;
    let selLoc = (_locations$find = locations.find(loc => loc.id === urlLocationId)) !== null && _locations$find !== void 0 ? _locations$find : null;
    if (!selLoc) {
      var _ref, _monitor$locations2;
      selLoc = (_ref = monitor === null || monitor === void 0 ? void 0 : (_monitor$locations2 = monitor.locations) === null || _monitor$locations2 === void 0 ? void 0 : _monitor$locations2.find(loc => loc.id === urlLocationId)) !== null && _ref !== void 0 ? _ref : null;
    }
    return selLoc;
  }, [locations, urlLocationId, monitor === null || monitor === void 0 ? void 0 : monitor.locations]);
};
exports.useSelectedLocation = useSelectedLocation;