"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlledField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _reactUse = require("react-use");
var _reactHookForm = require("react-hook-form");
var _hooks = require("../hooks");
var _state = require("../../../state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ControlledField = ({
  component: FieldComponent,
  props,
  fieldKey,
  field,
  formRowProps,
  error,
  dependenciesValues,
  dependenciesFieldMeta,
  isInvalid
}) => {
  const {
    setValue,
    getFieldState,
    reset,
    formState,
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const {
    locations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  const {
    space
  } = (0, _hooks.useKibanaSpace)();
  const isEdit = (0, _hooks.useIsEditFlow)();
  const [onChangeArgs, setOnChangeArgs] = (0, _react.useState)(undefined);
  (0, _reactUse.useDebounce)(async () => {
    if (onChangeArgs !== undefined) {
      await (trigger === null || trigger === void 0 ? void 0 : trigger()); // Manually invalidate whole form to make dependency validations reactive
    }
  }, 500, [onChangeArgs]);
  const handleChange = (0, _react.useCallback)(async (...event) => {
    if (typeof (event === null || event === void 0 ? void 0 : event[0]) === 'string' && !getFieldState(fieldKey).isTouched) {
      // This is needed for composite fields like code editors
      setValue(fieldKey, event[0], {
        shouldTouch: true
      });
    }
    field.onChange(...event);
    setOnChangeArgs(event);
  },
  // Do not depend on `field`
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [setOnChangeArgs]);
  const generatedProps = props ? props({
    field,
    setValue,
    trigger,
    reset,
    locations: locations.map(location => ({
      ...location,
      key: location.id
    })),
    dependencies: dependenciesValues,
    dependenciesFieldMeta,
    space: space === null || space === void 0 ? void 0 : space.id,
    isEdit,
    formState
  }) : {};
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, formRowProps, {
    isInvalid: isInvalid,
    error: error
  }), /*#__PURE__*/_react.default.createElement(FieldComponent, (0, _extends2.default)({}, field, {
    checked: field.value || false,
    defaultValue: field.value,
    onChange: handleChange
  }, generatedProps, {
    isInvalid: isInvalid,
    fullWidth: true
  })));
};
exports.ControlledField = ControlledField;