"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormattedComboBox = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormattedComboBox = ({
  onChange,
  onBlur,
  selectedOptions,
  ...props
}) => {
  const [formattedSelectedOptions, setSelectedOptions] = (0, _react.useState)(selectedOptions.map(option => ({
    label: option,
    key: option
  })));
  const [isInvalid, setInvalid] = (0, _react.useState)(false);
  const onOptionsChange = (0, _react.useCallback)(options => {
    setSelectedOptions(options);
    const formattedTags = options.map(option => option.label);
    onChange(formattedTags);
    setInvalid(false);
  }, [onChange, setSelectedOptions, setInvalid]);
  const onCreateOption = (0, _react.useCallback)(tag => {
    const formattedTag = tag.trim();
    const newOption = {
      label: formattedTag
    };
    onChange([...selectedOptions, formattedTag]);

    // Select the option.
    setSelectedOptions([...formattedSelectedOptions, newOption]);
  }, [onChange, formattedSelectedOptions, selectedOptions, setSelectedOptions]);
  const onSearchChange = (0, _react.useCallback)(searchValue => {
    if (!searchValue) {
      setInvalid(false);
      return;
    }
    setInvalid(!isValid(searchValue));
  }, [setInvalid]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    "data-test-subj": "syntheticsFleetComboBox",
    noSuggestions: true,
    selectedOptions: formattedSelectedOptions,
    onCreateOption: onCreateOption,
    onChange: onOptionsChange,
    onBlur: () => onBlur === null || onBlur === void 0 ? void 0 : onBlur(),
    onSearchChange: onSearchChange,
    isInvalid: isInvalid
  }, props));
};
exports.FormattedComboBox = FormattedComboBox;
const isValid = value => {
  // Ensure that the tag is more than whitespace
  return value.match(/\S+/) !== null;
};