"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JourneyLastScreenshot = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_journey_steps = require("../../monitor_details/hooks/use_journey_steps");
var _status_badge = require("../monitor_test_result/status_badge");
var _journey_step_screenshot_container = require("./journey_step_screenshot_container");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JourneyLastScreenshot = ({
  checkGroupId,
  size,
  timestamp
}) => {
  var _lastSignificantStep$, _lastSignificantStep$2, _lastSignificantStep$3;
  const {
    loading: stepsLoading,
    stepEnds
  } = (0, _use_journey_steps.useJourneySteps)(checkGroupId);
  const lastSignificantStep = (0, _react.useMemo)(() => {
    const copy = [...stepEnds];
    // Sort desc by timestamp
    copy.sort((stepA, stepB) => Number(new Date(stepB['@timestamp'])) - Number(new Date(stepA['@timestamp'])));
    return copy.find(stepEnd => {
      var _stepEnd$synthetics$s, _stepEnd$synthetics, _stepEnd$synthetics$s2;
      return (0, _status_badge.parseBadgeStatus)((_stepEnd$synthetics$s = stepEnd === null || stepEnd === void 0 ? void 0 : (_stepEnd$synthetics = stepEnd.synthetics) === null || _stepEnd$synthetics === void 0 ? void 0 : (_stepEnd$synthetics$s2 = _stepEnd$synthetics.step) === null || _stepEnd$synthetics$s2 === void 0 ? void 0 : _stepEnd$synthetics$s2.status) !== null && _stepEnd$synthetics$s !== void 0 ? _stepEnd$synthetics$s : 'skipped') !== 'skipped';
    });
  }, [stepEnds]);
  return /*#__PURE__*/_react.default.createElement(_journey_step_screenshot_container.JourneyStepScreenshotContainer, {
    checkGroup: lastSignificantStep === null || lastSignificantStep === void 0 ? void 0 : lastSignificantStep.monitor.check_group,
    initialStepNumber: lastSignificantStep === null || lastSignificantStep === void 0 ? void 0 : (_lastSignificantStep$ = lastSignificantStep.synthetics) === null || _lastSignificantStep$ === void 0 ? void 0 : (_lastSignificantStep$2 = _lastSignificantStep$.step) === null || _lastSignificantStep$2 === void 0 ? void 0 : _lastSignificantStep$2.index,
    stepStatus: lastSignificantStep === null || lastSignificantStep === void 0 ? void 0 : (_lastSignificantStep$3 = lastSignificantStep.synthetics.payload) === null || _lastSignificantStep$3 === void 0 ? void 0 : _lastSignificantStep$3.status,
    allStepsLoaded: !stepsLoading,
    retryFetchOnRevisit: false,
    size: size,
    timestamp: timestamp
  });
};
exports.JourneyLastScreenshot = JourneyLastScreenshot;