"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.thumbnailStyle = exports.SCREENSHOT_NOT_AVAILABLE = exports.SCREENSHOT_LOADING_ARIA_LABEL = exports.EmptyThumbnail = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _screenshot_size = require("./screenshot_size");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const thumbnailStyle = {
  padding: 0,
  margin: 'auto',
  objectFit: 'contain',
  overflow: 'hidden',
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center'
};
exports.thumbnailStyle = thumbnailStyle;
const EmptyThumbnail = ({
  isLoading = false,
  animateLoading,
  size = _screenshot_size.THUMBNAIL_SCREENSHOT_SIZE,
  unavailableMessage,
  borderRadius
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    width,
    height
  } = (0, _screenshot_size.getConfinedScreenshotSize)(size);
  const noDataMessage = unavailableMessage !== null && unavailableMessage !== void 0 ? unavailableMessage : SCREENSHOT_NOT_AVAILABLE;
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
    _react.default.createElement("div", {
      "data-test-subj": "stepScreenshotPlaceholder",
      role: "img",
      "aria-label": isLoading ? SCREENSHOT_LOADING_ARIA_LABEL : noDataMessage,
      title: isLoading ? SCREENSHOT_LOADING_ARIA_LABEL : noDataMessage,
      style: {
        ...thumbnailStyle,
        width,
        height,
        background: (0, _eui.useEuiBackgroundColor)('subdued'),
        border: euiTheme.border.thin,
        ...(borderRadius ? {
          borderRadius
        } : {})
      },
      onClick: e => {
        // We don't want the placeholder to be clickable
        e.stopPropagation();
        e.preventDefault();
      },
      onKeyDown: e => {
        // We don't want the placeholder to be clickable
        e.stopPropagation();
      }
    }, isLoading && animateLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      "data-test-subj": "stepScreenshotPlaceholderLoading",
      isLoading: isLoading,
      height: height,
      width: width
    }, /*#__PURE__*/_react.default.createElement("span", null)) :
    // when we're loading and `animateLoading` is false we simply render an un-animated div to fill the space
    isLoading ? /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "stepScreenshotPlaceholderLoading",
      style: {
        width: '100%'
      }
    }) : /*#__PURE__*/_react.default.createElement("div", {
      style: {
        border: 'none',
        display: 'flex',
        flexDirection: 'column',
        alignItems: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "data-test-subj": "stepScreenshotNotAvailable",
      type: "eyeClosed",
      color: euiTheme.colors.disabledText
    }), unavailableMessage ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: euiTheme.colors.disabledText
    }, unavailableMessage) : null))
  );
};
exports.EmptyThumbnail = EmptyThumbnail;
const SCREENSHOT_LOADING_ARIA_LABEL = _i18n.i18n.translate('xpack.synthetics.monitor.step.screenshot.ariaLabel', {
  defaultMessage: 'Step screenshot is being loaded.'
});
exports.SCREENSHOT_LOADING_ARIA_LABEL = SCREENSHOT_LOADING_ARIA_LABEL;
const SCREENSHOT_NOT_AVAILABLE = _i18n.i18n.translate('xpack.synthetics.monitor.step.screenshot.notAvailable', {
  defaultMessage: 'Step screenshot is not available.'
});
exports.SCREENSHOT_NOT_AVAILABLE = SCREENSHOT_NOT_AVAILABLE;