"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRetrieveStepImage = void 0;
var _react = require("react");
var _runtime_types = require("../../../../../../common/runtime_types");
var _use_composite_image = require("../../../hooks/use_composite_image");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRetrieveStepImage = ({
  timestamp,
  checkGroup,
  stepStatus,
  hasIntersected,
  imgPath,
  testNowMode,
  retryFetchOnRevisit
}) => {
  var _imageResult$imgPath$, _imageResult$imgPath;
  const [imgState, setImgState] = (0, _react.useState)({});
  const skippedStep = stepStatus === 'skipped';
  const imageResult = useGetStepScreenshotUrls(checkGroup, imgPath, imgState);
  const isImageUrlAvailable = (_imageResult$imgPath$ = imageResult === null || imageResult === void 0 ? void 0 : (_imageResult$imgPath = imageResult[imgPath]) === null || _imageResult$imgPath === void 0 ? void 0 : _imageResult$imgPath.url) !== null && _imageResult$imgPath$ !== void 0 ? _imageResult$imgPath$ : false;
  const shouldFetch = (0, _react.useMemo)(() => {
    var _imgState$imgPath$att, _imgState$imgPath;
    const shouldRetry = retryFetchOnRevisit || !((_imgState$imgPath$att = (_imgState$imgPath = imgState[imgPath]) === null || _imgState$imgPath === void 0 ? void 0 : _imgState$imgPath.attempts) !== null && _imgState$imgPath$att !== void 0 ? _imgState$imgPath$att : 0 > 0);
    return !skippedStep && hasIntersected && !isImageUrlAvailable && shouldRetry && checkGroup;
  }, [checkGroup, hasIntersected, imgPath, imgState, isImageUrlAvailable, retryFetchOnRevisit, skippedStep]);
  (0, _react.useEffect)(() => {
    async function run() {
      if (shouldFetch) {
        setImgState(prevState => {
          return getUpdatedState({
            prevState,
            imgPath,
            increment: true,
            loading: true
          });
        });
        const backoffOptions = !testNowMode ? {
          shouldBackoff: false
        } : undefined;
        try {
          (0, _state.getJourneyScreenshot)(imgPath, backoffOptions).then(data => setImgState(prevState => getUpdatedState({
            prevState,
            imgPath,
            increment: false,
            data,
            loading: false
          })));
        } catch (e) {
          setImgState(prevState => {
            return getUpdatedState({
              prevState,
              imgPath,
              increment: false,
              loading: false
            });
          });
        }
      }
    }
    run();
  }, [imgPath, shouldFetch, testNowMode]);
  return imageResult;
};

/**
 * This hooks takes care of whether the image is of type `ScreenshotImageBlob` or
 * `ScreenshotRefImageData`. It returns the plain `imageUrl: string` in both cases
 * along with whether the image is being loaded/composing.
 */
exports.useRetrieveStepImage = useRetrieveStepImage;
function useGetStepScreenshotUrls(checkGroup, imgPath, dataResult) {
  var _dataResult$imgPath, _dataResult$imgPath2;
  const [imgDataState, setImgDataState] = (0, _react.useState)();

  // Retrieve `maxSteps` from any available step of the checkGroup
  const maxSteps = (0, _react.useMemo)(() => {
    var _Object$entries$find, _Object$entries$find$, _Object$entries$find$2;
    return checkGroup ? (_Object$entries$find = Object.entries(dataResult).find(([key, value]) => {
      var _value$data;
      return key.includes(checkGroup) && (value === null || value === void 0 ? void 0 : (_value$data = value.data) === null || _value$data === void 0 ? void 0 : _value$data.maxSteps);
    })) === null || _Object$entries$find === void 0 ? void 0 : (_Object$entries$find$ = _Object$entries$find[1]) === null || _Object$entries$find$ === void 0 ? void 0 : (_Object$entries$find$2 = _Object$entries$find$.data) === null || _Object$entries$find$2 === void 0 ? void 0 : _Object$entries$find$2.maxSteps : undefined;
  }, [checkGroup, dataResult]);
  const screenshotRef = (0, _runtime_types.isScreenshotRef)((_dataResult$imgPath = dataResult[imgPath]) === null || _dataResult$imgPath === void 0 ? void 0 : _dataResult$imgPath.data) ? (_dataResult$imgPath2 = dataResult[imgPath]) === null || _dataResult$imgPath2 === void 0 ? void 0 : _dataResult$imgPath2.data : undefined;
  const {
    isComposing,
    imgSrc
  } = (0, _use_composite_image.useComposeImageFromRef)(screenshotRef);
  (0, _react.useEffect)(() => {
    var _dataResult$imgPath3, _dataResult$imgPath3$, _dataResult$imgPath4, _dataResult$imgPath$l, _dataResult$imgPath5;
    const url = screenshotRef ? imgSrc : (_dataResult$imgPath3 = dataResult[imgPath]) === null || _dataResult$imgPath3 === void 0 ? void 0 : (_dataResult$imgPath3$ = _dataResult$imgPath3.data) === null || _dataResult$imgPath3$ === void 0 ? void 0 : _dataResult$imgPath3$.src;
    const stepName = (_dataResult$imgPath4 = dataResult[imgPath]) === null || _dataResult$imgPath4 === void 0 ? void 0 : _dataResult$imgPath4.stepName;
    const isLoading = ((_dataResult$imgPath$l = (_dataResult$imgPath5 = dataResult[imgPath]) === null || _dataResult$imgPath5 === void 0 ? void 0 : _dataResult$imgPath5.loading) !== null && _dataResult$imgPath$l !== void 0 ? _dataResult$imgPath$l : false) || isComposing;
    setImgDataState(prevState => {
      return getUpdatedState({
        prevState,
        imgPath,
        maxSteps,
        url,
        stepName,
        loading: isLoading
      });
    });
  }, [imgPath, maxSteps, dataResult, screenshotRef, isComposing, imgSrc]);
  return imgDataState;
}
function getUpdatedState({
  prevState,
  imgPath,
  increment,
  url,
  stepName,
  maxSteps,
  data,
  loading
}) {
  var _prevState$imgPath$at, _prevState$imgPath, _ref, _prevState$imgPath2, _ref2, _prevState$imgPath3, _prevState$imgPath4, _prevState$imgPath5, _prevState$imgPath5$d, _ref3, _data$stepName, _prevState$imgPath6;
  const newAttempts = ((_prevState$imgPath$at = prevState === null || prevState === void 0 ? void 0 : (_prevState$imgPath = prevState[imgPath]) === null || _prevState$imgPath === void 0 ? void 0 : _prevState$imgPath.attempts) !== null && _prevState$imgPath$at !== void 0 ? _prevState$imgPath$at : 0) + (increment ? 1 : 0);
  const newData = (_ref = data !== null && data !== void 0 ? data : prevState === null || prevState === void 0 ? void 0 : (_prevState$imgPath2 = prevState[imgPath]) === null || _prevState$imgPath2 === void 0 ? void 0 : _prevState$imgPath2.data) !== null && _ref !== void 0 ? _ref : null;
  const newLoading = (_ref2 = loading !== null && loading !== void 0 ? loading : prevState === null || prevState === void 0 ? void 0 : (_prevState$imgPath3 = prevState[imgPath]) === null || _prevState$imgPath3 === void 0 ? void 0 : _prevState$imgPath3.loading) !== null && _ref2 !== void 0 ? _ref2 : false;
  const newUrl = url !== null && url !== void 0 ? url : prevState === null || prevState === void 0 ? void 0 : (_prevState$imgPath4 = prevState[imgPath]) === null || _prevState$imgPath4 === void 0 ? void 0 : _prevState$imgPath4.url;
  const newMaxSteps = maxSteps !== null && maxSteps !== void 0 ? maxSteps : prevState === null || prevState === void 0 ? void 0 : (_prevState$imgPath5 = prevState[imgPath]) === null || _prevState$imgPath5 === void 0 ? void 0 : (_prevState$imgPath5$d = _prevState$imgPath5.data) === null || _prevState$imgPath5$d === void 0 ? void 0 : _prevState$imgPath5$d.maxSteps;
  const newStepName = (_ref3 = (_data$stepName = data === null || data === void 0 ? void 0 : data.stepName) !== null && _data$stepName !== void 0 ? _data$stepName : stepName) !== null && _ref3 !== void 0 ? _ref3 : prevState === null || prevState === void 0 ? void 0 : (_prevState$imgPath6 = prevState[imgPath]) === null || _prevState$imgPath6 === void 0 ? void 0 : _prevState$imgPath6.stepName;
  return {
    ...prevState,
    [imgPath]: {
      attempts: newAttempts,
      data: newData,
      url: newUrl,
      stepName: newStepName,
      maxSteps: newMaxSteps,
      loading: newLoading
    }
  };
}