"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.READ = exports.NoPermissionsTooltip = exports.NEED_PRIVATE_LOCATIONS_PERMISSION = exports.NEED_PERMISSIONS_PRIVATE_LOCATIONS = exports.FleetPermissionsCallout = exports.CANNOT_PERFORM_ACTION_SYNTHETICS = exports.CANNOT_PERFORM_ACTION_PUBLIC_LOCATIONS = exports.ALL = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FleetPermissionsCallout = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: NEED_PERMISSIONS_PRIVATE_LOCATIONS,
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, NEED_PRIVATE_LOCATIONS_PERMISSION), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.privateLocations.needFleetPermission.description",
    defaultMessage: "Once there is an agent policy available, you'll be able to manage private locations and monitors with the regular Synthetics app privileges."
  })));
};

/**
 * If canEditSynthetics  is false, then wrap the children with a tooltip
 * so that a reason can be conveyed to the user explaining why the action is disabled.
 */
exports.FleetPermissionsCallout = FleetPermissionsCallout;
const NoPermissionsTooltip = ({
  canEditSynthetics = true,
  canUsePublicLocations = true,
  children
}) => {
  const disabledMessage = getRestrictionReasonLabel(canEditSynthetics, canUsePublicLocations);
  if (disabledMessage) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: disabledMessage
    }, /*#__PURE__*/_react.default.createElement("span", null, children));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
exports.NoPermissionsTooltip = NoPermissionsTooltip;
function getRestrictionReasonLabel(canEditSynthetics = true, canUsePublicLocations = true) {
  const message = !canEditSynthetics ? CANNOT_PERFORM_ACTION_SYNTHETICS : undefined;
  if (message) {
    return message;
  }
  return !canUsePublicLocations ? CANNOT_PERFORM_ACTION_PUBLIC_LOCATIONS : undefined;
}
const NEED_PERMISSIONS_PRIVATE_LOCATIONS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.privateLocations.needPermissions', {
  defaultMessage: "You're missing some Kibana privileges to manage private locations"
});
exports.NEED_PERMISSIONS_PRIVATE_LOCATIONS = NEED_PERMISSIONS_PRIVATE_LOCATIONS;
const ALL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.privileges.all', {
  defaultMessage: 'All'
});
exports.ALL = ALL;
const READ = _i18n.i18n.translate('xpack.synthetics.monitorManagement.privileges.read', {
  defaultMessage: 'Read'
});
exports.READ = READ;
const NEED_PRIVATE_LOCATIONS_PERMISSION = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.synthetics.monitorManagement.privateLocations.needFleetPermission",
  defaultMessage: "In order to create private locations, you need an agent policy. You are not authorized to create Fleet agent policies. It requires the {all} for Fleet and at least {read} for Integerations kibana priviliges.",
  values: {
    all: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, `"${ALL}"`),
    read: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, `"${READ}"`)
  }
});
exports.NEED_PRIVATE_LOCATIONS_PERMISSION = NEED_PRIVATE_LOCATIONS_PERMISSION;
const CANNOT_PERFORM_ACTION_SYNTHETICS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.noSyntheticsPermissions', {
  defaultMessage: 'You do not have sufficient permissions to perform this action.'
});
exports.CANNOT_PERFORM_ACTION_SYNTHETICS = CANNOT_PERFORM_ACTION_SYNTHETICS;
const CANNOT_PERFORM_ACTION_PUBLIC_LOCATIONS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.canUsePublicLocations', {
  defaultMessage: 'You do not have sufficient permissions to use Elastic managed locations.'
});
exports.CANNOT_PERFORM_ACTION_PUBLIC_LOCATIONS = CANNOT_PERFORM_ACTION_PUBLIC_LOCATIONS;